/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.mimemail;

import javax.mail.internet.MimeMultipart;
/**
 * This class overrides the class MimeMultipart to avoid the varied generation of the content type header.
 * TODO Do we really need this class ? (Is the standard behavior described below really a bug ?)
 * @author ibr
 *
 */
public class MixedMimeMultipart extends MimeMultipart {
	// JAVA Mail API write sometimes content type by MixedMimeMultipart 
	//in one line (without /r/n) but sometimes in two lines
	public MixedMimeMultipart(){
		super();
		if (!contentType.contains("\r\n")){
			int pos = contentType.indexOf(';');
			if (pos > 0){
				StringBuilder buff = new StringBuilder(contentType.length() + 2);
				buff.append(contentType.substring(0, pos + 1)).append(' ').append("\r\n")
				.append('	').append(contentType.substring(pos + 2,contentType.length()));
				contentType = buff.toString();
			}
		}
	}

}
