/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.json.push;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import com.openexchange.usm.connector.commands.PushNotificationType;
import com.openexchange.usm.json.USMSessionCredentials;

public class PushNotificationService {

	private static PushNotificationService _instance;

	private boolean isRunning;

	private Map<USMSessionCredentials, PushNotificationType> _map;

	public static synchronized PushNotificationService getInstance() {
		if (_instance == null) {
			_instance = new PushNotificationService();
		}
		return _instance;
	}

	public void setValue(USMSessionCredentials key, PushNotificationType value) {
		_map.put(key, value);
	}

	public PushNotificationType getValue(USMSessionCredentials key) {
		return _map.get(key);
	}

	public boolean containKey(USMSessionCredentials key) {
		return _map.containsKey(key);
	}

	public PushNotificationType removeValue(USMSessionCredentials key) {
		return _map.remove(key);
	}

	public void startup() {
		if (isRunning)
			return;
		_map = new ConcurrentHashMap<USMSessionCredentials, PushNotificationType>();
		isRunning = true;
	}

	public void shutdown() {
		if (!isRunning)
			return;
		_map.clear();
		isRunning = false;
	}

	public boolean isRun() {
		return isRunning;
	}
}
