/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.connector.exceptions;

import com.openexchange.usm.api.exceptions.USMException;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.json.ConnectorBundleErrorCodes;

/**
 * {@link MultipleOperationsOnDataObjectException}
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class MultipleOperationsOnDataObjectException extends USMException {

    private final DataObject _object;

    public MultipleOperationsOnDataObjectException(DataObject o) {
        super(
            ConnectorBundleErrorCodes.MULTIPLE_OPERATIONS_ON_SAME_UUID,
            "More than one action requested on DataObject with uuid " + o.getUUID());
        _object = o;
    }

    public DataObject getDataObject() {
        return _object;
    }
}
