/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.database.ox.osgi;

import com.openexchange.context.ContextService;
import com.openexchange.database.CreateTableService;
import com.openexchange.database.DatabaseService;
import com.openexchange.groupware.update.UpdateTaskProviderService;
import com.openexchange.usm.api.database.DatabaseAccess;
import com.openexchange.usm.database.ox.CreateUSMTablesService;
import com.openexchange.usm.database.ox.OXDBService;
import com.openexchange.usm.database.ox.USMOXDeleteListener;
import com.openexchange.usm.database.ox.USMUpdateTaskProvider;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link DatabaseAccessActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class DatabaseAccessActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { ContextService.class, DatabaseService.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        ContextService contextService = (ContextService) getService(ContextService.class);
        DatabaseService databaseService = (DatabaseService) getService(DatabaseService.class);

        registerService(DatabaseAccess.class, new OXDBService(contextService, databaseService));
        LOG.info("OXDBService registered.");

        registerService(CreateTableService.class, new CreateUSMTablesService());
        LOG.info("CreateTableService 'CreateUSMTablesService' registered.");

        registerService(UpdateTaskProviderService.class, new USMUpdateTaskProvider(databaseService));
        LOG.info("UpdateTaskProviderService 'USMUpdateTaskProvider' registered");

        registerService(USMOXDeleteListener.class, new USMOXDeleteListener());
        LOG.info("USMOXDeleteListener registered.");
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        LOG.info("OXDBService unregistered.");
        LOG.info("CreateTableService unregistered.");
        LOG.info("UpdateTaskProviderService unregistered.");
        LOG.info("USMOXDeleteListener unregistered.");
    }
}
