/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.datatypes.folder;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import com.openexchange.usm.api.datatypes.AbstractDataType;
import com.openexchange.usm.api.session.Session;

public class FolderPermissionDataType extends AbstractDataType<FolderPermission> {

    public FolderPermissionDataType() {
        super("FolderPermission");
    }

    @Override
    public void addToJSONArray(Session session, JSONArray parent, Object value) throws JSONException {
        parent.put(((FolderPermission) value).toJSONObject());
    }

    @Override
    public FolderPermission checkValue(Object o) {
        if (o != null && !(o instanceof FolderPermission))
            generateTypeError(o);
        return (FolderPermission) o;
    }

    @Override
    public FolderPermission extractFromJSONArray(Session session, JSONArray array, int index) throws JSONException {
        return array.isNull(index) ? new FolderPermission() : new FolderPermission(array.getJSONObject(index));
    }

    @Override
    public FolderPermission extractFromJSONObject(Session session, JSONObject jsonObject, String field) throws JSONException {
        return jsonObject.isNull(field) ? new FolderPermission() : new FolderPermission(jsonObject.getJSONObject(field));
    }

    @Override
    public void storeInJSONObject(Session session, JSONObject parent, String field, Object value) throws JSONException {
        parent.put(field, ((FolderPermission) value).toJSONObject());
    }
}
