/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.clt;

import javax.management.ObjectName;

/**
 * {@link JMXObjectNames} Storage class for JMX ObjectNames used by USM
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public final class JMXObjectNames {

    public static final ObjectName USM_SESSION_INFO_MBEAN = createUSMSessionInfoMBeanObjectName();

    private JMXObjectNames() {
        // Prevent instantiation
    }

    private static ObjectName createUSMSessionInfoMBeanObjectName() {
        try {
            return new ObjectName("com.openexchange.usm.session", "name", "USMSessionInformation");
        } catch (Exception e) {
            System.err.println("Can't create ObjectName for USMSessionInfoMBean");
            e.printStackTrace(System.err);
            return null;
        }
    }
}
