/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.session.assets;

public class USMSessionID {

    private final int _cid;

    private final int _usmSessionId;

    /**
     * Initializes a new {@link USMSessionID}.
     * 
     * @param cid
     * @param usmSessionId
     */
    public USMSessionID(int cid, int usmSessionId) {
        _cid = cid;
        _usmSessionId = usmSessionId;
    }

    /**
     * @return the contextID
     */
    public int getCID() {
        return _cid;
    }

    /**
     * @return the USMSessionID
     */
    public int getUSMSessionID() {
        return _usmSessionId;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + _cid;
        result = prime * result + _usmSessionId;
        return result;
    }

    /*
     * (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        USMSessionID other = (USMSessionID) obj;
        if (_cid != other._cid)
            return false;
        if (_usmSessionId != other._usmSessionId)
            return false;
        return true;
    }
}
