/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.exceptions;

/**
 * Thrown when the UUID already exists /is reserved and the client is trying to map another OX Object to it.
 * 
 * @author ldo
 */
public class UUIDAlreadyMappedException extends InvalidUUIDException {

    /**
	 * 
	 */
    private static final long serialVersionUID = 1L;

    private static final String DEFAULT_ERROR_MESSAGE = "UUID already exists";

    public UUIDAlreadyMappedException(int errorCode) {
        super(errorCode, DEFAULT_ERROR_MESSAGE);
    }

    public UUIDAlreadyMappedException(int errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }

    public UUIDAlreadyMappedException(int errorCode, String message) {
        super(errorCode, message);
    }

    public UUIDAlreadyMappedException(int errorCode, Throwable cause) {
        super(errorCode, cause);
    }

}
