/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.datatypes;

/**
 * Special ArrayDataType - elements do not need to be in the same order for two arrays to be considered equal. 
 * 
 * @author ldo
 *
 */
public class UnsortedArrayDataType extends ArrayDataType {

	public UnsortedArrayDataType(DataType<?> elementType) {
		super(elementType);
	}
	
	
	@Override
	public boolean isEqual(Object v1, Object v2) {
		Object[] value1 = (Object[]) v1;
		Object[] value2 = (Object[]) v2;
		if (value1.length != value2.length)
			return false;
		boolean found = false;
		for (int i = 0; i < value1.length; i++) {
			found = false;
			for (int j = 0; j < value2.length; j++) {
				if (_elementType.isEqual(value1[i], value2[j]))
					found = true;
			}
			if(!found) return false;
		}
		return true;
	}

}
