/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.contenttypes.common;

import java.util.Map;

/**
 * Support class that allows global access to lookup maps for ContentTypes, which can be
 * used for fast field access using names instead of indexes.
 * 
 * @author afe
 *
 */
public interface FieldMapStorage extends ContentTypeListener {
	/**
	 * For the given ContentType, provide a Map that allows for fast index lookup for
	 * its fields by their names.
	 * 
	 * @param contentType
	 * @return Map that provides name to index mapping for the fields of the provided ContentType
	 */
	Map<String, Integer> getFieldNameToIndexMap(ContentType contentType);
}
