/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.ox_json.impl;

import org.apache.commons.httpclient.HttpClient;
import com.openexchange.usm.api.session.OXConnectionInformation;

public class OXConnectionData implements OXConnectionInformation {

    private static final long serialVersionUID = -210011280973132893L;

    private final String _sessionID;

    private final int userId;

    private final int contextId;

    private final HttpClient _httpClient;

    private ResourceInputStreamImpl _currentResourceInputStream;

    public OXConnectionData(String sessionID, int userId, int contextId, HttpClient client) {
        _sessionID = sessionID;
        this.userId = userId;
        this.contextId = contextId;
        _httpClient = client;
    }

    public String getSessionID() {
        return _sessionID;
    }

    public HttpClient getHttpClient() {
        return _httpClient;
    }

    @Override
    public String toString() {
        return "OX session " + _sessionID;
    }

    public ResourceInputStreamImpl getCurrentResourceInputStream() {
        return _currentResourceInputStream;
    }

    public void setCurrentResourceInputStream(ResourceInputStreamImpl currentResourceInputStream) {
        _currentResourceInputStream = currentResourceInputStream;
    }

    /**
     * Gets the userId
     *
     * @return The userId
     */
    public int getUserId() {
        return userId;
    }

    /**
     * Gets the contextId
     *
     * @return The contextId
     */
    public int getContextId() {
        return contextId;
    }
}
