/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.database.ox.update;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.usm.database.ox.TableDefinition;
import com.openexchange.usm.database.ox.USMUpdateExceptionCodes;
import com.openexchange.usm.database.ox.USMUpdateTaskProvider;
import com.openexchange.usm.util.Toolkit;

public class USMClearTablesUpdateTaskV2 extends USMBaseUpdateTaskV2 {

	public USMClearTablesUpdateTaskV2(USMUpdateTaskProvider provider) {
		super(provider);
	}

	@Override
	protected void doPerform(PerformParameters params) throws OXException {
        Connection con = params.getConnection();
        PreparedStatement stmt = null;
        try {
            DatabaseMetaData metaData = con.getMetaData();
            for (int i = TableDefinition.TABLE_NAMES.length - 1; i >= 0; i--) {
                String tableName = TableDefinition.TABLE_NAMES[i];
                if (tableExists(tableName, metaData)) {
                    stmt = con.prepareStatement("DELETE FROM " + tableName);
                    stmt.executeUpdate();
                    stmt.close();
                    stmt = null;
                }
            }
        } catch (SQLException e) {
            throw USMUpdateExceptionCodes.SQL_ERROR.create(e);
        } finally {
            Toolkit.close(stmt);
        }
	}

	@Override
    public String[] getDependencies() {
		return new String[] { USMUUIDTablesUpdateTaskV2.class.getName() };
	}
}
