/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.datatypes.mail;

import org.json.JSONException;
import com.openexchange.usm.api.datatypes.NumberDataType;

public class FlagsDataType extends NumberDataType {
	@Override
	protected Number convertToNumber(Object o) throws JSONException {
		return removeRecentFlag(super.convertToNumber(o));
	}

	private Number removeRecentFlag(Number n) {
		int flags = n.intValue();
		if ((flags & 16) == 0)
			return n;
		return flags - 16;
	}

	@Override
	public Number checkValue(Object o) {
		if (o == null)
			return null;
		if (!(o instanceof Number))
			generateTypeError(o);
		return removeRecentFlag((Number) o);
	}
}
