/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.groups.osgi;

import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.ox.json.OXJSONAccess;
import com.openexchange.usm.contenttypes.groups.impl.GroupsContentTypeImpl;
import com.openexchange.usm.contenttypes.groups.impl.GroupsContentTypeTransferHandler;
import com.openexchange.usm.util.AbstractUSMActivator;

/**
 * {@link GroupsContentTypeActivator}
 * 
 * @author <a href="mailto:ioannis.chouklis@open-xchange.com">Ioannis Chouklis</a>
 */
public class GroupsContentTypeActivator extends AbstractUSMActivator {

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#getNeededServices()
     */
    @Override
    protected Class<?>[] getNeededServices() {
        return new Class<?>[] { OXJSONAccess.class };
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#register(org.osgi.framework.BundleContext)
     */
    @Override
    protected void register() {
        OXJSONAccess jsonAccess = (OXJSONAccess) getService(OXJSONAccess.class);

        GroupsContentTypeImpl ct = new GroupsContentTypeImpl();
        GroupsContentTypeTransferHandler cth = new GroupsContentTypeTransferHandler(ct, jsonAccess);
        ct.setTransferHandler(cth);

        registerService(ContentType.class, ct);
        LOG.info("Groups Content Type registered.");
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.usm.util.AbstractUSMActivator#unregister(org.osgi.framework.BundleContext)
     */
    @Override
    protected void unregister() {
        LOG.info("Groups Content Type unregistered.");
    }

}
