/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.contenttypes.groups.impl;

import static com.openexchange.usm.api.datatypes.DataTypes.STRING;
import com.openexchange.usm.api.contenttypes.common.CommonConstants;
import com.openexchange.usm.api.contenttypes.common.ContentTypeField;
import com.openexchange.usm.api.contenttypes.common.DefaultContentTypes;
import com.openexchange.usm.api.contenttypes.groups.GroupsConstants;
import com.openexchange.usm.api.contenttypes.groups.GroupsContentType;
import com.openexchange.usm.api.contenttypes.transferhandlers.ContentTypeTransferHandler;
import com.openexchange.usm.api.session.DataObject;
import com.openexchange.usm.contenttypes.util.AbstractContentType;

public class GroupsContentTypeImpl extends AbstractContentType implements GroupsContentType {

    private static final ContentTypeField[] FIELDS = {
        new ContentTypeField(-1800, CommonConstants.FIELD_ID, STRING, false, true, false, false), // ID
        new ContentTypeField(-1801, CommonConstants.FOLDER_ID, STRING, false, false, true, false), // Object ID of the parent folder. Dummy
                                                                                                   // field. Always empty
        new ContentTypeField(-1802, GroupsConstants.DISPLAY_NAME, STRING), // Display Name
        new ContentTypeField(-1803, GroupsConstants.NAME, STRING), // Name with character restrictions
        new ContentTypeField(-1804, GroupsConstants.MEMBERS, STRING, true), // Array of group member id's
    };

    private GroupsContentTypeTransferHandler _transferHandler;

    @Override
    public int getCode() {
        return DefaultContentTypes.GROUPS_CODE;
    }

    @Override
    public ContentTypeField[] getFields() {
        return FIELDS;
    }

    @Override
    public String getID() {
        return DefaultContentTypes.GROUPS_ID;
    }

    @Override
    public Object getObjectGroupOwner(DataObject object) {
        return object.getID();
    }

    @Override
    public ContentTypeTransferHandler getTransferHandler() {
        return _transferHandler;
    }

    public void setTransferHandler(GroupsContentTypeTransferHandler transferHandler) {
        _transferHandler = transferHandler;
    }

    @Override
    public boolean supportsPIMAttachments() {
        return false;
    }

    @Override
    public int hashCode() {
        return 191731;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof GroupsContentType))
            return false;
        return true;
    }

    @Override
    public boolean canBeFolderElementsContentType() {
        return false;
    }
}
