/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.clt.eas12;

/**
 * {@link EASProtocolVersion}
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public enum EASProtocolVersion {
    UNKNOWN("Unknown"), EAS_2_5("2.5"), EAS_12_0("12.0"), EAS_12_1("12.1", 121), EAS_14_0("14.0", 140);

    private final String _representation;

    private final int _code;

    private EASProtocolVersion(String representation) {
        _representation = representation;
        _code = -1;
    }

    private EASProtocolVersion(String representation, int code) {
        _representation = representation;
        _code = code;
    }

    public boolean isAtLeastVersion(EASProtocolVersion requiredVersion) {
        return ordinal() >= requiredVersion.ordinal();
    }
    
    public boolean isVersionLessThan(EASProtocolVersion requiredVersion) {
        return ordinal() < requiredVersion.ordinal();
    }

    @Override
    public String toString() {
        return _representation;
    }

    public int getCode() {
        return _code;
    }

    public static EASProtocolVersion parse(String representation) {
        for (EASProtocolVersion v : values()) {
            if (v.toString().equals(representation))
                return v;
        }
        return UNKNOWN;
    }

    public static EASProtocolVersion fromCode(int protocolNumber) {
        for (EASProtocolVersion v : values()) {
            if (v.getCode() == protocolNumber)
                return v;
        }
        return UNKNOWN;
    }
}
