/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.session.assets;

import java.io.Serializable;

/**
 * Identifies one Data Object. 
 * To be used for storing data objects in the Cache. 
 * @author ldo
 *
 */
public class DataObjectIdentifier implements Serializable {

	/**
	 * TODO: change to generated
	 */
	private static final long serialVersionUID = -1L;

	final String _user;
	final String _device;
	final String _objectID;
	final long _timestamp;

	public DataObjectIdentifier(String user, String device, String objectID, long timestamp) {
		_user = user;
		_device = device;
		_objectID = objectID;
		_timestamp = timestamp;
	}

	public String getUser() {
		return _user;
	}

	public String getDevice() {
		return _device;
	}

	public String getObjectID() {
		return _objectID;
	}

	public long getTimestamp() {
		return _timestamp;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		DataObjectIdentifier other = (DataObjectIdentifier) obj;
		if (!_user.equals(other._user))
			return false;
		if (!_device.equals(other._device))
			return false;
		if (!_objectID.equals(other._objectID))
			return false;
		if (_timestamp != other._timestamp)
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + _user.hashCode();
		result = prime * result + _device.hashCode();
		result = prime * result + _objectID.hashCode();
		result = prime * result + (int) _timestamp;
		return result;
	}

	@Override
	public String toString() {
		return _user + ':' + _device + ':' + _objectID + ':' + _timestamp;
	}
}
