/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.exceptions;

import com.openexchange.usm.api.session.DataObject;

/**
 * Helper class used by SynchronizationConflictException to report conflicting changes between client and server.
 * Note that the server change may not always be available (will be set to null) if the conflict was detected by
 * a low level method (i.e. an error was reported by OX) and couldn't be mapped by a higher level method (e.g. if
 * no cached or current server information is available). The server change will also not be available on failed
 * creations.
 * 
 * @author afe
 *
 */
public class ConflictingChange {
	private final DataObject _clientChange;
	private final DataObject _serverChange;

	public ConflictingChange(DataObject clientChange, DataObject serverChange) {
		_clientChange = clientChange;
		_serverChange = serverChange;
	}

	public DataObject getClientChange() {
		return _clientChange;
	}

	public DataObject getServerChange() {
		return _serverChange;
	}

	@Override
	public String toString() {
		return _clientChange + "<=>" + _serverChange;
	}
}
