/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.database;

import java.sql.Connection;

/**
 * Extends {@link DatabaseAccess} by methods to retrieve/release connection w/o a timeout.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public interface DatabaseAccessWithNoTimeoutSupport extends DatabaseAccess {

    /**
     * Provides an Connection to store custom data w/o a timeout. Every Connection that is retrieved from the DatabaseAccess has to be
     * closed later.
     *
     * @param context
     * @return
     * @throws StorageAccessException if the Connection can not be retrieved
     */
    EncapsulatedConnection getNoTimeout(int contextID) throws StorageAccessException;

    /**
     * Releases a previously requested read/write SQL Connection so that it can be reused.
     *
     * @param connection
     * @throws StorageAccessException if an error occurred while releasing the Connection
     */
    void backNoTimeout(int contextID, Connection connection) throws StorageAccessException;

}
