/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.usm.api.contenttypes.folder;

import java.util.Collection;
import com.openexchange.usm.api.session.DataObject;

/**
 * {@link OXFolderContent}
 * 
 * @author <a href="mailto:afe@microdoc.de">Alexander Feess</a>
 */
public class OXFolderContent {

    private final DataObject[] _objects;

    private final boolean _complete;

    public OXFolderContent(boolean complete, Collection<DataObject> objects) {
        this(complete, objects.toArray(new DataObject[objects.size()]));
    }

    public OXFolderContent(boolean complete, DataObject... objects) {
        _complete = complete;
        _objects = objects;
    }

    /**
     * @return the current state of all DataObjects read from OX
     */
    public DataObject[] getObjects() {
        return _objects;
    }

    /**
     * @return true if all DataObjects (within the sync interval) have been read, false if at least 1 new object has been omitted
     */
    public boolean isComplete() {
        return _complete;
    }

    @Override
    public String toString() {
        if (_complete)
            return "OXFolderContent(" + _objects.length + " objects)";
        return "OXFolderContent(" + _objects.length + " objects, incomplete)";
    }
}
