/*
 * @copyright Copyright (c) OX Software GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */
package com.openexchange.usm.api.contenttypes.folder;

import com.openexchange.usm.api.contenttypes.common.ContentType;
import com.openexchange.usm.api.contenttypes.transferhandlers.FolderContentTypeTransferHandler;
import com.openexchange.usm.api.session.Folder;
import com.openexchange.usm.api.session.Session;

/**
 * Provides all relevant information about the Folder content type.
 * 
 * @author ldo
 *
 */
public interface FolderContentType extends ContentType {

	String FOLDER_TREE = "Folder.Tree";

	/**
	 * The FolderContentType must return a special kind of DataObject on newDataObject that
	 * implements the extended interface Folder
	 * 
	 * @param session
	 * @return
	 */
	@Override
    Folder newDataObject(Session session);

	/**
	 * @return Special ContentTypeTransferHandler with additional methods for root folders,...
	 */
	@Override
    FolderContentTypeTransferHandler getTransferHandler();
	
	/**
     * @return provided FolderContentType
     */
    FolderContentType getFolderContentType();
}
