/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.tools.monitoring;

import com.openexchange.office.tools.doc.DocumentType;


/**
 * {@link CloseEvent}
 *
 * @author <a href="mailto:kai.ahrens@open-xchange.com">Kai Ahrens</a>
 */
public class CloseEvent extends DocumentEvent {

    /**
     * Initializes a new {@link CloseEvent}.
     * @param eventType
     */
    public CloseEvent(DocumentType documentType, CloseType closeType) {
        super(documentType, EventType.CLOSE);

        m_closeType = closeType;
    }

    /**
     * @return The set CloseType
     */
    public CloseType getCloseType() {
        return m_closeType;
    }

    // - Members ----------------------------------------------------------------------------

    private CloseType m_closeType = CloseType.NONE;
}
