/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 * 
 * Use is subject to license terms.
 * 
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */
package org.odftoolkit.odfdom.pkg.manifest;

import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.odfdom.pkg.OdfName;

import com.openexchange.office.filter.odf.AttrNS;

/**
 * Manifest implementation of OpenDocument attribute  {@odf.attribute manifest:key-size}.
 *
 */
public class KeySizeAttribute extends AttrNS {

	public static final OdfName ATTRIBUTE_NAME = OdfName.newName("urn:oasis:names:tc:opendocument:xmlns:manifest:1.0", "manifest:key-size");

	/**
	 * Create the instance of OpenDocument attribute {@odf.attribute manifest:key-size}.
	 *
	 * @param ownerDocument       The type is <code>OdfFileDom</code>
	 */
	public KeySizeAttribute(OdfFileDom ownerDocument) {
		super(ownerDocument, ATTRIBUTE_NAME.getUri(), ATTRIBUTE_NAME.getQName());
	}

	/**
	 * @return Returns the name of this attribute.
	 */
	@Override
	public String getName() {
		return ATTRIBUTE_NAME.getLocalName();
	}

	/**
	 * @param value The <code>int</code> value of the attribute.
	 */
	public void setIntValue(int value) {
		super.setValue(String.valueOf(value));
	}

	/**
	 * @return Returns the <code>int</code> value of the attribute
	 */
	public int intValue() {
		String val = super.getValue();
		try {
			return Integer.parseInt(val);
		} catch (NumberFormatException e) {
			// TODO: validation handling/logging
			throw (e);
		}
	}

	/**
	 * @param attrValue The <code>String</code> value of the attribute.
	 * @throws IllegalArgumentException If the provided attribute value is invalid
	 */
	@Override
	public void setValue(String attrValue) {
		try {
			super.setValue(attrValue);
		} catch (NullPointerException e) {
			// TODO: validation handling/logging
			throw new IllegalArgumentException(e);
		} catch (IllegalArgumentException e) {
			// TODO: validation handling/logging
			throw (e);
		}
	}

	/**
	 * @return Returns the <code>String</code> value of the attribute
	 */
	@Override
	public String getValue() {
		try {
			return super.getValue();
		} catch (IllegalArgumentException e) {
			// TODO: validation handling/logging
			throw new NumberFormatException("the value of key-size is not valid");
		}
	}

	/**
	 * @return Returns whether this attribute is known to be of type ID (i.e. xml:id ?)
	 */
	@Override
	public boolean isId() {
		return false;
	}
}
