/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.math.BigInteger;
import java.util.ListIterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.FnCompare;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;

public abstract class AbstractCollationEqualFunction
extends Function {
    public AbstractCollationEqualFunction(QName name, int arity) {
        super(name, arity);
    }

    public AbstractCollationEqualFunction(QName name, int min_arity, int max_arity) {
        super(name, min_arity, max_arity);
    }

    protected static boolean hasValue(AnyType itema, AnyType itemb, DynamicContext context, String collationURI) throws DynamicError {
        XSString xstr1;
        XSDuration durat;
        NumericType numericat;
        XSBoolean boolat;
        XSString itemStr = new XSString(itema.getStringValue());
        if (AbstractCollationEqualFunction.isBoolean(itema, itemb) && (boolat = (XSBoolean)itema).eq(itemb, context)) {
            return true;
        }
        if (AbstractCollationEqualFunction.isNumeric(itema, itemb) && (numericat = (NumericType)itema).eq(itemb, context)) {
            return true;
        }
        if (AbstractCollationEqualFunction.isDuration(itema, itemb) && (durat = (XSDuration)itema).eq(itemb, context)) {
            return true;
        }
        return AbstractCollationEqualFunction.needsStringComparison(itema, itemb) && FnCompare.compare_string(collationURI, xstr1 = new XSString(itema.getStringValue()), itemStr, context).equals(BigInteger.ZERO);
    }

    protected static boolean hasValue(ResultBuffer rs, AnyAtomicType item, DynamicContext context, String collationURI) throws DynamicError {
        XSString itemStr = new XSString(item.getStringValue());
        ListIterator<Item> i = rs.iterator();
        while (i.hasNext()) {
            XSString xstr1;
            XSDuration durat;
            NumericType numericat;
            XSBoolean boolat;
            AnyType at = (AnyType)i.next();
            if (!(at instanceof CmpEq)) continue;
            if (AbstractCollationEqualFunction.isBoolean(item, at) && (boolat = (XSBoolean)at).eq(item, context)) {
                return true;
            }
            if (AbstractCollationEqualFunction.isNumeric(item, at) && (numericat = (NumericType)at).eq(item, context)) {
                return true;
            }
            if (AbstractCollationEqualFunction.isDuration(item, at) && (durat = (XSDuration)at).eq(item, context)) {
                return true;
            }
            if (!AbstractCollationEqualFunction.needsStringComparison(item, at) || !FnCompare.compare_string(collationURI, xstr1 = new XSString(at.getStringValue()), itemStr, context).equals(BigInteger.ZERO)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDuration(AnyAtomicType item, AnyType at) {
        return at instanceof XSDuration && item instanceof XSDuration;
    }

    protected static boolean isBoolean(AnyAtomicType item, AnyType at) {
        return at instanceof XSBoolean && item instanceof XSBoolean;
    }

    protected static boolean isNumeric(AnyAtomicType item, AnyType at) {
        return at instanceof NumericType && item instanceof NumericType;
    }

    protected static boolean needsStringComparison(AnyAtomicType item, AnyType at) {
        AnyAtomicType anyItem = item;
        return AbstractCollationEqualFunction.needsStringComparison((AnyType)anyItem, at);
    }

    protected static boolean isDuration(AnyType item, AnyType at) {
        return at instanceof XSDuration && item instanceof XSDuration;
    }

    protected static boolean isDate(AnyType item, AnyType at) {
        return at instanceof XSDateTime && item instanceof XSDateTime;
    }

    protected static boolean isBoolean(AnyType cmptype, AnyType at) {
        return at instanceof XSBoolean && cmptype instanceof XSBoolean;
    }

    protected static boolean isNumeric(AnyType item, AnyType at) {
        return at instanceof NumericType && item instanceof NumericType;
    }

    protected static boolean needsStringComparison(AnyType item, AnyType at) {
        if (item instanceof NumericType) {
            XSDouble d;
            XSFloat f;
            if (at instanceof XSFloat && (f = (XSFloat)at).nan()) {
                return true;
            }
            if (at instanceof XSDouble && (d = (XSDouble)at).nan()) {
                return true;
            }
        }
        if (at instanceof XSString) {
            return true;
        }
        return at instanceof XSUntypedAtomic;
    }
}

