/*
 *  Copyright 2010-2012, Plutext Pty Ltd.
 *
 *  This file is part of pptx4j, a component of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */
package org.pptx4j.pml;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementRefs;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.openexchange.office.filter.core.INodeAccessor;
import com.openexchange.office.filter.core.DLList;
import com.openexchange.office.filter.core.DLNode;


/**
 * <p>Java class for CT_CommentList complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_CommentList">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="cm" type="{http://schemas.openxmlformats.org/presentationml/2006/main}CT_Comment" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_CommentList", propOrder = {
    "content"
})
@XmlRootElement(name="cmLst")
public class CTCommentList implements INodeAccessor<CTComment> {

    @XmlElementRefs({
        @XmlElementRef(name = "cm", namespace = "http://schemas.openxmlformats.org/presentationml/2006/main", type = CTComment.class),
    })
    protected DLList<CTComment> content;

    @Override
    public DLList<CTComment> getContent() {
        if (content== null) {
            content = new DLList<CTComment>();
        }
        return content;
    }

    public CTComment getCommentByIdx(long idx) {
        DLNode<CTComment> node = getContent().getFirstNode();
        while(node!=null) {
            if(node.getData().getIdx()==idx) {
                return node.getData();
            }
            node = node.getNext();
        }
        return null;
    }
}
