/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.scd;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.impl.scd.Axis;
import org.apache.xerces.impl.scd.SCDException;
import org.apache.xerces.impl.scd.Step;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.XML11Char;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;

class SCDParser {
    private List steps = new ArrayList(15);
    private static final int CHARTYPE_AT = 1;
    private static final int CHARTYPE_TILDE = 2;
    private static final int CHARTYPE_PERIOD = 3;
    private static final int CHARTYPE_STAR = 4;
    private static final int CHARTYPE_ZERO = 5;
    private static final int CHARTYPE_1_THROUGH_9 = 6;
    private static final int CHARTYPE_NC_NAMESTART = 7;
    private static final int CHARTYPE_NC_NAME = 8;
    private static final int CHARTYPE_OPEN_BRACKET = 9;
    private static final int CHARTYPE_CLOSE_BRACKET = 10;
    private static final int CHARTYPE_OPEN_PAREN = 11;
    private static final int CHARTYPE_CLOSE_PAREN = 12;
    private static final int CHARTYPE_COLON = 13;
    private static final int CHARTYPE_SLASH = 14;
    private static final int CHARTYPE_NOMORE = 0;
    private static final short LIST_SIZE = 15;
    public static final QName WILDCARD = new QName(null, "*", "*", null);
    public static final QName ZERO = new QName(null, "0", "0", null);

    private static int getCharType(int c) throws SCDException {
        switch (c) {
            case 64: {
                return 1;
            }
            case 126: {
                return 2;
            }
            case 46: {
                return 3;
            }
            case 42: {
                return 4;
            }
            case 58: {
                return 13;
            }
            case 47: {
                return 14;
            }
            case 40: {
                return 11;
            }
            case 41: {
                return 12;
            }
            case 91: {
                return 9;
            }
            case 93: {
                return 10;
            }
            case 48: {
                return 5;
            }
        }
        if (c == 0) {
            return 0;
        }
        if (c >= 49 && c <= 57) {
            return 6;
        }
        if (XML11Char.isXML11NCNameStart(c)) {
            return 7;
        }
        if (XML11Char.isXML11NCName(c)) {
            return 8;
        }
        throw new SCDException("Error in SCP: Unsupported character " + (char)c + " (" + c + ")");
    }

    public static char charAt(String s, int position) {
        if (position >= s.length()) {
            return '\uffff';
        }
        return s.charAt(position);
    }

    private static QName readQName(String step, int[] finalPosition, int currentPosition, NamespaceContext nsContext) throws SCDException {
        return SCDParser.readNameTest(step, finalPosition, currentPosition, nsContext);
    }

    private static QName readNameTest(String step, int[] finalPosition, int currentPosition, NamespaceContext nsContext) throws SCDException {
        int initialPosition = currentPosition;
        int start = currentPosition;
        String prefix = "";
        String localPart = null;
        if (SCDParser.charAt(step, currentPosition) == '*') {
            finalPosition[0] = currentPosition + 1;
            return WILDCARD;
        }
        if (SCDParser.charAt(step, currentPosition) == '0') {
            finalPosition[0] = currentPosition + 1;
            return ZERO;
        }
        if (XML11Char.isXML11NCNameStart(SCDParser.charAt(step, currentPosition))) {
            while (XML11Char.isXML11NCName(SCDParser.charAt(step, ++currentPosition))) {
            }
            prefix = step.substring(initialPosition, currentPosition);
            if (SCDParser.charAt(step, currentPosition) == ':') {
                if (XML11Char.isXML11NCNameStart(SCDParser.charAt(step, ++currentPosition))) {
                    initialPosition = currentPosition;
                    while (XML11Char.isXML11NCName(SCDParser.charAt(step, currentPosition++))) {
                    }
                    localPart = step.substring(initialPosition, currentPosition - 1);
                }
                if (localPart == null) {
                    localPart = prefix;
                    prefix = "";
                }
                finalPosition[0] = currentPosition - 1;
            } else {
                finalPosition[0] = currentPosition;
                localPart = prefix;
                prefix = "";
            }
            String rawname = step.substring(start, finalPosition[0]);
            if (nsContext != null) {
                String uri = nsContext.getURI(prefix.intern());
                if ("".equals(prefix)) {
                    return new QName(prefix, localPart, rawname, uri);
                }
                if (uri != null) {
                    return new QName(prefix, localPart, rawname, uri);
                }
                throw new SCDException("Error in SCP: The prefix \"" + prefix + "\" is undeclared in this context");
            }
            throw new SCDException("Error in SCP: Namespace context is null");
        }
        throw new SCDException("Error in SCP: Invalid nametest starting character '" + SCDParser.charAt(step, currentPosition) + "'");
    }

    private static int scanNCName(String data, int currentPosition) {
        if (XML11Char.isXML11NCNameStart(SCDParser.charAt(data, currentPosition))) {
            while (XML11Char.isXML11NCName(SCDParser.charAt(data, ++currentPosition))) {
            }
        }
        return currentPosition;
    }

    private static int scanXmlnsSchemeData(String data, int currentPosition) throws SCDException {
        char c = '\u0000';
        int balanceParen = 0;
        do {
            if ((c = SCDParser.charAt(data, currentPosition)) >= '\u0000' && c <= '\u10ffff') {
                if (c != '^') {
                    ++currentPosition;
                    if (c == '(') {
                        ++balanceParen;
                        continue;
                    }
                    if (c != ')') continue;
                    if (--balanceParen == -1) {
                        return currentPosition - 1;
                    }
                    if (SCDParser.charAt(data, currentPosition - 2) != '(') continue;
                    throw new SCDException("Error in SCD: empty xmlns scheme data between '(' and ')'");
                }
                if (SCDParser.charAt(data, currentPosition + 1) == '(' || SCDParser.charAt(data, currentPosition + 1) == ')' || SCDParser.charAt(data, currentPosition + 1) == '^') {
                    currentPosition += 2;
                    continue;
                }
                throw new SCDException("Error in SCD: '^' character is used as a non escape character at position " + ++currentPosition);
            }
            throw new SCDException("Error in SCD: the character '" + c + "' at position " + ++currentPosition + " is invalid for xmlns scheme data");
        } while (currentPosition < data.length());
        String s = "";
        if (balanceParen != -1) {
            s = "Unbalanced parentheses exist within xmlns scheme data section";
        }
        throw new SCDException("Error in SCD: Attempt to read an invalid xmlns Scheme data. " + s);
    }

    private static int skipWhiteSpaces(String data, int currentPosition) {
        while (XML11Char.isXML11Space(SCDParser.charAt(data, currentPosition))) {
            ++currentPosition;
        }
        return currentPosition;
    }

    private static int readPredicate(String step, int[] finalPosition, int currentPosition) throws SCDException {
        int end = step.indexOf(93, currentPosition);
        if (end >= 0) {
            try {
                int i = Integer.parseInt(step.substring(currentPosition, end));
                if (i > 0) {
                    finalPosition[0] = end + 1;
                    return i;
                }
                throw new SCDException("Error in SCP: Invalid predicate value " + i);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                throw new SCDException("Error in SCP: A NumberFormatException occurred while reading the predicate");
            }
        }
        throw new SCDException("Error in SCP: Attempt to read an invalid predicate starting from position " + ++currentPosition);
    }

    public List parseSCP(String scp, NamespaceContext nsContext, boolean isRelative) throws SCDException {
        this.steps.clear();
        if (scp.length() == 1 && scp.charAt(0) == '/') {
            this.steps.add(new Step(100, null, 0));
            return this.steps;
        }
        if (isRelative) {
            if ("./".equals(scp.substring(0, 2))) {
                scp = scp.substring(1);
            } else if (scp.charAt(0) != '/') {
                scp = '/' + scp;
            } else {
                throw new SCDException("Error in incomplete SCP: Invalid starting character");
            }
        }
        int stepStart = 0;
        int[] currentPosition = new int[]{0};
        while (currentPosition[0] < scp.length()) {
            if (SCDParser.charAt(scp, currentPosition[0]) == '/') {
                if (SCDParser.charAt(scp, currentPosition[0] + 1) == '/') {
                    if (currentPosition[0] + 1 != scp.length() - 1) {
                        this.steps.add(new Step(27, WILDCARD, 0));
                        stepStart = currentPosition[0] + 2;
                    } else {
                        stepStart = currentPosition[0] + 1;
                    }
                } else {
                    stepStart = currentPosition[0] != scp.length() - 1 ? currentPosition[0] + 1 : currentPosition[0];
                }
                Step step = SCDParser.processStep(scp, currentPosition, stepStart, nsContext);
                this.steps.add(step);
                continue;
            }
            throw new SCDException("Error in SCP: Invalid character '" + SCDParser.charAt(scp, currentPosition[0]) + " ' at position" + currentPosition[0]);
        }
        return this.steps;
    }

    private static Step processStep(String step, int[] newPosition, int currentPosition, NamespaceContext nsContext) throws SCDException {
        short axis = -1;
        QName nameTest = null;
        int predicate = 0;
        switch (SCDParser.getCharType(SCDParser.charAt(step, currentPosition))) {
            case 1: {
                axis = 0;
                nameTest = SCDParser.readNameTest(step, newPosition, currentPosition + 1, nsContext);
                break;
            }
            case 2: {
                axis = 2;
                nameTest = SCDParser.readNameTest(step, newPosition, currentPosition + 1, nsContext);
                break;
            }
            case 3: {
                axis = 23;
                nameTest = WILDCARD;
                newPosition[0] = currentPosition + 1;
                break;
            }
            case 5: {
                axis = 1;
                nameTest = ZERO;
                newPosition[0] = currentPosition + 1;
                break;
            }
            case 4: {
                axis = 1;
                nameTest = WILDCARD;
                newPosition[0] = currentPosition + 1;
                break;
            }
            case 7: {
                QName name = SCDParser.readQName(step, newPosition, currentPosition, nsContext);
                int newPos = newPosition[0];
                if (newPosition[0] == step.length()) {
                    axis = 1;
                    nameTest = name;
                    break;
                }
                if (SCDParser.charAt(step, newPos) == ':' && SCDParser.charAt(step, newPos + 1) == ':') {
                    axis = Axis.qnameToAxis(name.rawname);
                    if (axis == 26) {
                        throw new SCDException("Error in SCP: Extension axis {" + name.rawname + "} not supported!");
                    }
                    nameTest = SCDParser.readNameTest(step, newPosition, newPos + 2, nsContext);
                    break;
                }
                if (SCDParser.charAt(step, newPos) == '(') {
                    throw new SCDException("Error in SCP: Extension accessor not supported!");
                }
                if (SCDParser.charAt(step, newPos) == '/') {
                    axis = 1;
                    nameTest = name;
                    return new Step(axis, nameTest, predicate);
                }
                axis = 1;
                nameTest = name;
                break;
            }
            default: {
                throw new SCDException("Error in SCP: Invalid character '" + SCDParser.charAt(step, currentPosition) + "' at position " + currentPosition);
            }
        }
        if (newPosition[0] < step.length()) {
            if (SCDParser.charAt(step, newPosition[0]) == '[') {
                predicate = SCDParser.readPredicate(step, newPosition, newPosition[0] + 1);
            } else {
                if (SCDParser.charAt(step, newPosition[0]) == '/') {
                    return new Step(axis, nameTest, predicate);
                }
                throw new SCDException("Error in SCP: Unexpected character '" + SCDParser.charAt(step, newPosition[0]) + "' at position " + newPosition[0]);
            }
        }
        if (SCDParser.charAt(step, newPosition[0]) == '/') {
            return new Step(axis, nameTest, predicate);
        }
        if (newPosition[0] < step.length()) {
            throw new SCDException("Error in SCP: Unexpected character '" + step.charAt(newPosition[0]) + "' at the end");
        }
        return new Step(axis, nameTest, predicate);
    }

    public List parseRelativeSCD(String relativeSCD, boolean isIncompleteSCD) throws SCDException {
        int[] currentPosition = new int[]{0};
        NamespaceSupport nsContext = new NamespaceSupport();
        while (currentPosition[0] < relativeSCD.length()) {
            if ("xmlns".equals(relativeSCD.substring(currentPosition[0], currentPosition[0] + 5))) {
                currentPosition[0] = SCDParser.readxmlns(relativeSCD, nsContext, currentPosition[0] + 5);
                continue;
            }
            if ("xscd".equals(relativeSCD.substring(currentPosition[0], currentPosition[0] + 4))) {
                String data = relativeSCD.substring(currentPosition[0] + 4, relativeSCD.length());
                if (SCDParser.charAt(data, 0) == '(' && SCDParser.charAt(data, data.length() - 1) == ')') {
                    return this.parseSCP(data.substring(1, data.length() - 1), nsContext, isIncompleteSCD);
                }
                currentPosition[0] = currentPosition[0] + 1;
                throw new SCDException("Error in SCD: xscd() part is invalid at position " + currentPosition[0]);
            }
            currentPosition[0] = currentPosition[0] + 1;
            throw new SCDException("Error in SCD: Expected 'xmlns' or 'xscd' at position " + currentPosition[0]);
        }
        currentPosition[0] = currentPosition[0] + 1;
        throw new SCDException("Error in SCD: Error at position " + currentPosition[0]);
    }

    private static int readxmlns(String data, NamespaceContext nsContext, int currentPosition) throws SCDException {
        if (SCDParser.charAt(data, currentPosition++) == '(') {
            int pos = currentPosition;
            if ((currentPosition = SCDParser.scanNCName(data, currentPosition)) == pos) {
                throw new SCDException("Error in SCD: Missing namespace name at position " + ++currentPosition);
            }
            String name = data.substring(pos, currentPosition);
            if (SCDParser.charAt(data, currentPosition = SCDParser.skipWhiteSpaces(data, currentPosition)) != '=') {
                throw new SCDException("Error in SCD: Expected a  '=' character at position " + ++currentPosition);
            }
            ++currentPosition;
            pos = currentPosition = SCDParser.skipWhiteSpaces(data, currentPosition);
            if ((currentPosition = SCDParser.scanXmlnsSchemeData(data, currentPosition)) == pos) {
                throw new SCDException("Error in SCD: Missing namespace value at position " + ++currentPosition);
            }
            String uri = data.substring(pos, currentPosition);
            if (SCDParser.charAt(data, currentPosition) == ')') {
                nsContext.declarePrefix(name.intern(), uri.intern());
                return ++currentPosition;
            }
            throw new SCDException("Error in SCD: Invalid xmlns pointer part at position " + ++currentPosition);
        }
        throw new SCDException("Error in SCD: Invalid xmlns pointer part at position " + ++currentPosition);
    }
}

