/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.office.rt2.protocol;

import javax.jms.JMSException;
import javax.jms.Message;

import com.openexchange.office.rt2.protocol.RT2GoogleProtocol.BroadcastMessage;

public class GpbMessageJmsPostProcessor implements RT2MessagePostProcessor {

    public static final String HEADER_MSG_TYPE  = RT2Protocol.HEADER_PREFIX_INTERNAL + ".type";
    

    private final BroadcastMessage broadcastMsg;

    public GpbMessageJmsPostProcessor() {
        this.broadcastMsg = null;
    }    
    
    public GpbMessageJmsPostProcessor(BroadcastMessage broadcastMsg) {
        this.broadcastMsg = broadcastMsg;
    }

    @Override
    public Message postProcessMessage(Message msg) throws JMSException {
    	msg.setBooleanProperty(HEADER_VERSION_MSG_RCV, false);
    	msg.setBooleanProperty(HEADER_VERSION_MSG_SND, false);
    	if (broadcastMsg != null) {
    		msg.setStringProperty(HEADER_MSG_TYPE, broadcastMsg.getMsgType().name());
    	}
        msg.setBooleanProperty( HEADER_GPB_MSG, true);
        return msg;
    }
}
