/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite. If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.filter.odf.listlevel;

import org.xml.sax.Attributes;
import com.openexchange.office.filter.odf.AttributesImpl;
import com.openexchange.office.filter.odf.ElementNSWriter;
import com.openexchange.office.filter.odf.SaxContextHandler;
import com.openexchange.office.filter.odf.UnknownContentHandler;
import com.openexchange.office.filter.odf.properties.StylePropertiesBaseHandler;
import com.openexchange.office.filter.odf.properties.TextProperties;

public class ListLevelStyleBulletHandler extends SaxContextHandler {

	final ListLevelStyleBullet styleBullet;

	public ListLevelStyleBulletHandler(SaxContextHandler parentContext, ListLevelStyleBullet styleBullet) {
		super(parentContext);

		this.styleBullet = styleBullet;
	}

	@Override
	public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName) {
		if(qName.equals("style:list-level-properties")) {
			final ListLevelProperties listLevelProperties = new ListLevelProperties(new AttributesImpl(attributes));
			styleBullet.setListLevelProperties(listLevelProperties);
			return new ListLevelPropertiesHandler(this, listLevelProperties);
		}
		else if(qName.equals("style:text-properties")) {
			final TextProperties textProperties = new TextProperties(new AttributesImpl(attributes));
			styleBullet.setTextProperties(textProperties);
			return new StylePropertiesBaseHandler(this, textProperties);
		}
		final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
		return new UnknownContentHandler(this, element);
	}
}
