/*
 *  Copyright 2007-2013, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.docx4j.wml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.docx4j.adapter.LongAdapter;


/**
 * <p>Java class for anonymous complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType>
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="name" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="aliases" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="basedOn" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="next" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="link" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="autoRedefine" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="hidden" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="uiPriority" minOccurs="0">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;attribute name="val" use="required">
 *                   &lt;simpleType>
 *                     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}integer">
 *                     &lt;/restriction>
 *                   &lt;/simpleType>
 *                 &lt;/attribute>
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *         &lt;element name="semiHidden" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="unhideWhenUsed" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="qFormat" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="locked" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="personal" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="personalCompose" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="personalReply" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}BooleanDefaultTrue" minOccurs="0"/>
 *         &lt;element name="rsid" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_LongHexNumber" minOccurs="0"/>
 *         &lt;element name="pPr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_PPr" minOccurs="0"/>
 *         &lt;element name="rPr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_RPr" minOccurs="0"/>
 *         &lt;element name="tblPr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_TblPrBase" minOccurs="0"/>
 *         &lt;element name="trPr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_TrPr" minOccurs="0"/>
 *         &lt;element name="tcPr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_TcPr" minOccurs="0"/>
 *         &lt;element name="tblStylePr" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}CT_TblStylePr" maxOccurs="unbounded" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="type">
 *         &lt;simpleType>
 *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             &lt;enumeration value="paragraph"/>
 *             &lt;enumeration value="character"/>
 *             &lt;enumeration value="table"/>
 *             &lt;enumeration value="numbering"/>
 *           &lt;/restriction>
 *         &lt;/simpleType>
 *       &lt;/attribute>
 *       &lt;attribute name="styleId" type="{http://schemas.openxmlformats.org/wordprocessingml/2006/main}ST_String" />
 *       &lt;attribute name="default" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       &lt;attribute name="customStyle" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "name",
    "aliases",
    "basedOn",
    "next",
    "link",
    "autoRedefine",
    "hidden",
    "uiPriority",
    "semiHidden",
    "unhideWhenUsed",
    "qFormat",
    "locked",
    "personal",
    "personalCompose",
    "personalReply",
    "rsid",
    "pPr",
    "rPr",
    "tblPr",
    "trPr",
    "tcPr",
    "tblStylePr"
})
@XmlRootElement(name = "style")
public class Style {

    protected Style.Name name;
    protected Style.Aliases aliases;
    protected Style.BasedOn basedOn;
    protected Style.Next next;
    protected Style.Link link;
    protected BooleanDefaultTrue autoRedefine;
    protected BooleanDefaultTrue hidden;
    protected Style.UiPriority uiPriority;
    protected BooleanDefaultTrue semiHidden;
    protected BooleanDefaultTrue unhideWhenUsed;
    protected BooleanDefaultTrue qFormat;
    protected BooleanDefaultTrue locked;
    protected BooleanDefaultTrue personal;
    protected BooleanDefaultTrue personalCompose;
    protected BooleanDefaultTrue personalReply;
    protected CTLongHexNumber rsid;
    protected PPr pPr;
    protected RPr rPr;
    protected CTTblPrBase tblPr;
    protected TrPr trPr;
    protected TcPr tcPr;
    protected List<CTTblStylePr> tblStylePr;
    @XmlAttribute(name = "type", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected String type;
    @XmlAttribute(name = "styleId", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected String styleId;
    @XmlAttribute(name = "default", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected Boolean _default;
    @XmlAttribute(name = "customStyle", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
    protected Boolean customStyle;

    /**
     * Gets the value of the name property.
     *
     * @return
     *     possible object is
     *     {@link Style.Name }
     *
     */
    public Style.Name getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.Name }
     *
     */
    public void setName(Style.Name value) {
        this.name = value;
    }

    /**
     * Gets the value of the aliases property.
     *
     * @return
     *     possible object is
     *     {@link Style.Aliases }
     *
     */
    public Style.Aliases getAliases() {
        return aliases;
    }

    /**
     * Sets the value of the aliases property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.Aliases }
     *
     */
    public void setAliases(Style.Aliases value) {
        this.aliases = value;
    }

    /**
     * Gets the value of the basedOn property.
     *
     * @return
     *     possible object is
     *     {@link Style.BasedOn }
     *
     */
    public Style.BasedOn getBasedOn() {
        return basedOn;
    }

    /**
     * Sets the value of the basedOn property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.BasedOn }
     *
     */
    public void setBasedOn(Style.BasedOn value) {
        this.basedOn = value;
    }

    /**
     * Gets the value of the next property.
     *
     * @return
     *     possible object is
     *     {@link Style.Next }
     *
     */
    public Style.Next getNext() {
        return next;
    }

    /**
     * Sets the value of the next property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.Next }
     *
     */
    public void setNext(Style.Next value) {
        this.next = value;
    }

    /**
     * Gets the value of the link property.
     *
     * @return
     *     possible object is
     *     {@link Style.Link }
     *
     */
    public Style.Link getLink() {
        return link;
    }

    /**
     * Sets the value of the link property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.Link }
     *
     */
    public void setLink(Style.Link value) {
        this.link = value;
    }

    /**
     * Gets the value of the autoRedefine property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getAutoRedefine() {
        return autoRedefine;
    }

    /**
     * Sets the value of the autoRedefine property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setAutoRedefine(BooleanDefaultTrue value) {
        this.autoRedefine = value;
    }

    /**
     * Gets the value of the hidden property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getHidden() {
        return hidden;
    }

    /**
     * Sets the value of the hidden property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setHidden(BooleanDefaultTrue value) {
        this.hidden = value;
    }

    /**
     * Gets the value of the uiPriority property.
     *
     * @return
     *     possible object is
     *     {@link Style.UiPriority }
     *
     */
    public Style.UiPriority getUiPriority() {
        return uiPriority;
    }

    /**
     * Sets the value of the uiPriority property.
     *
     * @param value
     *     allowed object is
     *     {@link Style.UiPriority }
     *
     */
    public void setUiPriority(Style.UiPriority value) {
        this.uiPriority = value;
    }

    /**
     * Gets the value of the semiHidden property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getSemiHidden() {
        return semiHidden;
    }

    /**
     * Sets the value of the semiHidden property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setSemiHidden(BooleanDefaultTrue value) {
        this.semiHidden = value;
    }

    /**
     * Gets the value of the unhideWhenUsed property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getUnhideWhenUsed() {
        return unhideWhenUsed;
    }

    /**
     * Sets the value of the unhideWhenUsed property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setUnhideWhenUsed(BooleanDefaultTrue value) {
        this.unhideWhenUsed = value;
    }

    /**
     * Gets the value of the qFormat property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getQFormat() {
        return qFormat;
    }

    /**
     * Sets the value of the qFormat property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setQFormat(BooleanDefaultTrue value) {
        this.qFormat = value;
    }

    /**
     * Gets the value of the locked property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getLocked() {
        return locked;
    }

    /**
     * Sets the value of the locked property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setLocked(BooleanDefaultTrue value) {
        this.locked = value;
    }

    /**
     * Gets the value of the personal property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getPersonal() {
        return personal;
    }

    /**
     * Sets the value of the personal property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setPersonal(BooleanDefaultTrue value) {
        this.personal = value;
    }

    /**
     * Gets the value of the personalCompose property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getPersonalCompose() {
        return personalCompose;
    }

    /**
     * Sets the value of the personalCompose property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setPersonalCompose(BooleanDefaultTrue value) {
        this.personalCompose = value;
    }

    /**
     * Gets the value of the personalReply property.
     *
     * @return
     *     possible object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public BooleanDefaultTrue getPersonalReply() {
        return personalReply;
    }

    /**
     * Sets the value of the personalReply property.
     *
     * @param value
     *     allowed object is
     *     {@link BooleanDefaultTrue }
     *
     */
    public void setPersonalReply(BooleanDefaultTrue value) {
        this.personalReply = value;
    }

    /**
     * Gets the value of the rsid property.
     *
     * @return
     *     possible object is
     *     {@link CTLongHexNumber }
     *
     */
    public CTLongHexNumber getRsid() {
        return rsid;
    }

    /**
     * Sets the value of the rsid property.
     *
     * @param value
     *     allowed object is
     *     {@link CTLongHexNumber }
     *
     */
    public void setRsid(CTLongHexNumber value) {
        this.rsid = value;
    }

    /**
     * Gets the value of the pPr property.
     *
     * @return
     *     possible object is
     *     {@link PPr }
     *
     */
    public PPr getPPr(boolean forceCreate) {
        if(pPr==null&&forceCreate) {
            pPr = new PPr();
        }
        return pPr;
    }

    /**
     * Sets the value of the pPr property.
     *
     * @param value
     *     allowed object is
     *     {@link PPr }
     *
     */
    public void setPPr(PPr value) {
        this.pPr = value;
    }

    /**
     * Gets the value of the rPr property.
     *
     * @return
     *     possible object is
     *     {@link RPr }
     *
     */
    public RPr getRPr(boolean forceCreate) {
        if(rPr==null&&forceCreate) {
            rPr = new RPr();
        }
        return rPr;
    }

    /**
     * Sets the value of the rPr property.
     *
     * @param value
     *     allowed object is
     *     {@link RPr }
     *
     */
    public void setRPr(RPr value) {
        this.rPr = value;
    }

    /**
     * Gets the value of the tblPr property.
     *
     * @return
     *     possible object is
     *     {@link CTTblPrBase }
     *
     */
    public CTTblPrBase getTblPr(boolean forceCreate) {
        if(tblPr==null&&forceCreate) {
            tblPr = new CTTblPrBase();
        }
        return tblPr;
    }

    /**
     * Sets the value of the tblPr property.
     *
     * @param value
     *     allowed object is
     *     {@link CTTblPrBase }
     *
     */
    public void setTblPr(CTTblPrBase value) {
        this.tblPr = value;
    }

    /**
     * Gets the value of the trPr property.
     *
     * @return
     *     possible object is
     *     {@link TrPr }
     *
     */
    public TrPr getTrPr(boolean forceCreate) {
        if(trPr==null&&forceCreate) {
            trPr = new TrPr();
        }
        return trPr;
    }

    /**
     * Sets the value of the trPr property.
     *
     * @param value
     *     allowed object is
     *     {@link TrPr }
     *
     */
    public void setTrPr(TrPr value) {
        this.trPr = value;
    }

    /**
     * Gets the value of the tcPr property.
     *
     * @return
     *     possible object is
     *     {@link TcPr }
     *
     */
    public TcPr getTcPr(boolean forceCreate) {
        if(tcPr==null&&forceCreate)  {
            tcPr = new TcPr();
        }
        return tcPr;
    }

    /**
     * Sets the value of the tcPr property.
     *
     * @param value
     *     allowed object is
     *     {@link TcPr }
     *
     */
    public void setTcPr(TcPr value) {
        this.tcPr = value;
    }

    /**
     * Gets the value of the tblStylePr property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tblStylePr property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTblStylePr().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTTblStylePr }
     *
     *
     */
    public List<CTTblStylePr> getTblStylePr() {
        if (tblStylePr == null) {
            tblStylePr = new ArrayList<CTTblStylePr>();
        }
        return this.tblStylePr;
    }

    /**
     * Gets the value of the type property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setType(String value) {
        this.type = value;
    }

    /**
     * Gets the value of the styleId property.
     *
     * @return
     *     possible object is
     *     {@link String }
     *
     */
    public String getStyleId() {
        return styleId;
    }

    /**
     * Sets the value of the styleId property.
     *
     * @param value
     *     allowed object is
     *     {@link String }
     *
     */
    public void setStyleId(String value) {
        this.styleId = value;
    }

    /**
     * Gets the value of the default property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    public boolean isDefault() {
        if (_default == null) {
            return false;
        }
        return _default;
    }

    /**
     * Sets the value of the default property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setDefault(Boolean value) {
        this._default = value;
    }

    /**
     * Gets the value of the customStyle property.
     *
     * @return
     *     possible object is
     *     {@link Boolean }
     *
     */
    public Boolean isCustomStyle() {
        return customStyle;
    }

    /**
     * Sets the value of the customStyle property.
     *
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *
     */
    public void setCustomStyle(Boolean value) {
        this.customStyle = value;
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Aliases  {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
        protected String val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class BasedOn {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
        protected String val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
        public void setVal(String value) {
            this.val = value;
        }
    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Link {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
        protected String val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
        public void setVal(String value) {
            this.val = value;
        }
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Name {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
        protected String val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
        public void setVal(String value) {
            this.val = value;
        }
    }

    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class Next {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main")
        protected String val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link String }
         *
         */
        public String getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link String }
         *
         */
        public void setVal(String value) {
            this.val = value;
        }
    }


    /**
     * <p>Java class for anonymous complex type.
     *
     * <p>The following schema fragment specifies the expected content contained within this class.
     *
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;attribute name="val" use="required">
     *         &lt;simpleType>
     *           &lt;restriction base="{http://www.w3.org/2001/XMLSchema}integer">
     *           &lt;/restriction>
     *         &lt;/simpleType>
     *       &lt;/attribute>
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     *
     *
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "")
    public static class UiPriority {

        @XmlAttribute(name = "val", namespace = "http://schemas.openxmlformats.org/wordprocessingml/2006/main", required = true)
        @XmlJavaTypeAdapter(LongAdapter.class)
        protected Long val;

        /**
         * Gets the value of the val property.
         *
         * @return
         *     possible object is
         *     {@link Long }
         *
         */
        public Long getVal() {
            return val;
        }

        /**
         * Sets the value of the val property.
         *
         * @param value
         *     allowed object is
         *     {@link Long }
         *
         */
        public void setVal(Long value) {
            this.val = value;
        }
    }

    public void beforeMarshal(Marshaller marshaller) {
        if(_default!=null && !_default.booleanValue()) {    // docs-4119, ensure to only write default "true" vaules (regardless of the property
            _default = null;                                // value LO interprets the existence of this property as default "true" )
        }
    }
}
