/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NodeType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XPathDecimalFormat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSDecimal
extends NumericType {
    private static final String XS_DECIMAL = "xs:decimal";
    private BigDecimal _value;
    private XPathDecimalFormat format = new XPathDecimalFormat("0.####################");

    public XSDecimal() {
        this(BigDecimal.valueOf(0L));
    }

    public XSDecimal(BigDecimal x) {
        this._value = x;
    }

    public XSDecimal(String x) {
        this._value = new BigDecimal(x);
    }

    @Override
    public String string_type() {
        return XS_DECIMAL;
    }

    @Override
    public String type_name() {
        return "decimal";
    }

    @Override
    public String getStringValue() {
        if (this.zero()) {
            return "0";
        }
        this._value = new BigDecimal(this._value.toString().replaceFirst("0*", ""));
        return this.format.xpathFormat(this._value);
    }

    @Override
    public boolean zero() {
        return this._value.compareTo(new BigDecimal(0.0)) == 0;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence constructor(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        Item aat = arg.first();
        if (aat instanceof XSDuration || aat instanceof CalendarType || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (aat.getStringValue().indexOf("-INF") != -1) {
            throw DynamicError.cant_cast(null);
        }
        if (!this.isLexicalValue(aat.getStringValue())) {
            throw DynamicError.invalidLexicalValue(null);
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        try {
            return this.castDecimal(aat);
        }
        catch (NumberFormatException e) {
            throw DynamicError.cant_cast(null, e);
        }
    }

    protected boolean isLexicalValue(String value) {
        if (value.equalsIgnoreCase("inf")) {
            return false;
        }
        return !value.equalsIgnoreCase("-inf");
    }

    private boolean isCastable(Item aat) throws DynamicError {
        if (aat instanceof XSBoolean || aat instanceof NumericType) {
            return true;
        }
        if (aat.getStringValue().indexOf("E") != -1 || aat.getStringValue().indexOf("e") != -1) {
            return false;
        }
        return aat instanceof XSString || aat instanceof XSUntypedAtomic || aat instanceof NodeType;
    }

    private XSDecimal castDecimal(Item aat) {
        if (aat instanceof XSBoolean) {
            if (aat.getStringValue().equals("true")) {
                return new XSDecimal(new BigDecimal("1"));
            }
            return new XSDecimal(new BigDecimal("0"));
        }
        return new XSDecimal(aat.getStringValue());
    }

    @Deprecated
    public double double_value() {
        return this._value.doubleValue();
    }

    public BigDecimal getValue() {
        return this._value;
    }

    public void set_double(double x) {
        this._value = new BigDecimal(x);
    }

    @Override
    public boolean eq(AnyType at, DynamicContext dynamicContext) throws DynamicError {
        XSDecimal dt = null;
        if (!(at instanceof XSDecimal)) {
            ResultSequence rs = ResultSequenceFactory.create_new(at);
            org.eclipse.wst.xml.xpath2.api.ResultSequence crs = this.constructor(rs);
            if (crs.empty()) {
                throw DynamicError.throw_type_error();
            }
            Item cat = crs.first();
            dt = (XSDecimal)cat;
        } else {
            dt = (XSDecimal)at;
        }
        return this._value.compareTo(dt.getValue()) == 0;
    }

    @Override
    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        return this._value.compareTo(val.getValue()) == 1;
    }

    protected Item convertArg(AnyType arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence rs = ResultSequenceFactory.create_new(arg);
        rs = this.constructor(rs);
        Item carg = rs.first();
        return carg;
    }

    @Override
    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Item carg = this.convertArg(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        return this._value.compareTo(val.getValue()) == -1;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence plus(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this._value.add(dt.getValue())));
    }

    private org.eclipse.wst.xml.xpath2.api.ResultSequence convertResultSequence(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = arg;
        Iterator<Item> it = carg.iterator();
        while (it.hasNext()) {
            AnyType type = (AnyType)it.next();
            if (!type.string_type().equals("xs:untypedAtomic") && !type.string_type().equals("xs:string")) continue;
            throw DynamicError.invalidType();
        }
        carg = this.constructor(carg);
        return carg;
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence minus(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        Item at = this.get_single_arg(carg);
        if (!(at instanceof XSDecimal)) {
            DynamicError.throw_type_error();
        }
        XSDecimal dt = (XSDecimal)at;
        return ResultSequenceFactory.create_new(new XSDecimal(this._value.subtract(dt.getValue())));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence times(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        BigDecimal result = this._value.multiply(val.getValue());
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence div(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigDecimal result = this.getValue().divide(val.getValue(), 18, 6);
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence idiv(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        if (val.zero()) {
            throw DynamicError.div_zero(null);
        }
        BigInteger _ivalue = this._value.toBigInteger();
        BigInteger ival = val.getValue().toBigInteger();
        BigInteger result = _ivalue.divide(ival);
        return ResultSequenceFactory.create_new(new XSInteger(result));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence mod(org.eclipse.wst.xml.xpath2.api.ResultSequence arg) throws DynamicError {
        org.eclipse.wst.xml.xpath2.api.ResultSequence carg = this.convertResultSequence(arg);
        XSDecimal val = (XSDecimal)XSDecimal.get_single_type(carg, XSDecimal.class);
        BigDecimal result = XSDecimal.remainder(this._value, val.getValue());
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    public static BigDecimal remainder(BigDecimal value, BigDecimal divisor) {
        BigDecimal dividend = value.divide(divisor, 1);
        BigDecimal ceilDividend = new BigDecimal(dividend.toBigInteger());
        return value.subtract(ceilDividend.multiply(divisor));
    }

    @Override
    public org.eclipse.wst.xml.xpath2.api.ResultSequence unary_minus() {
        BigDecimal result = this._value.negate();
        return ResultSequenceFactory.create_new(new XSDecimal(result));
    }

    @Override
    public NumericType abs() {
        return new XSDecimal(this._value.abs());
    }

    @Override
    public NumericType ceiling() {
        BigDecimal ceiling = this._value.setScale(0, 2);
        return new XSDecimal(ceiling);
    }

    @Override
    public NumericType floor() {
        BigDecimal floor = this._value.setScale(0, 3);
        return new XSDecimal(floor);
    }

    @Override
    public NumericType round() {
        BigDecimal round = this._value.setScale(0, 0);
        return new XSDecimal(round);
    }

    @Override
    public NumericType round_half_to_even() {
        return this.round_half_to_even(0);
    }

    @Override
    public NumericType round_half_to_even(int precision) {
        BigDecimal round = this._value.setScale(precision, 6);
        return new XSDecimal(round);
    }

    @Override
    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_DECIMAL;
    }

    @Override
    public Number getNativeValue() {
        return this._value;
    }
}

