/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Stack;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XMLSchemaException;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSModelGroupImpl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XS11CMRestriction;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.util.SimpleLocator;
import org.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolHash;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xs.XSTypeDefinition;

class XS11Constraints
extends XSConstraints {
    public XS11Constraints() {
        super(SchemaGrammar.getXSAnyType((short)4), (short)4);
    }

    @Override
    public boolean overlapUPA(XSElementDecl element, XSWildcardDecl wildcard, SubstitutionGroupHandler sgHandler) {
        return false;
    }

    @Override
    protected final void checkElementDeclsConsistent(XSComplexTypeDecl type, XSParticleDecl particle, SymbolHash elemDeclHash, SubstitutionGroupHandler sgHandler, XSGrammarBucket grammarBucket, ArrayList wcList, Stack elemDeclStack) throws XMLSchemaException {
        XSWildcardDecl wc;
        if (particle.fType == 2) {
            return;
        }
        if (wcList.size() > 0) {
            wcList.clear();
        }
        if (elemDeclStack.size() > 0) {
            elemDeclStack.clear();
        }
        if (type.fOpenContent != null && (wc = type.fOpenContent.fWildcard) != null && wc.fProcessContents != 2) {
            wcList.add(wc);
        }
        if (particle.fType == 1) {
            elemDeclStack.push((XSElementDecl)particle.fValue);
        } else {
            this.preprocessModelGroupParticle((XSModelGroupImpl)particle.fValue, wcList, elemDeclStack);
        }
        while (!elemDeclStack.empty()) {
            XSElementDecl elem = (XSElementDecl)elemDeclStack.pop();
            this.findElemInTable(type, elem, elemDeclHash);
            if (elem.fScope == 1) {
                XSElementDecl[] subGroup = sgHandler.getSubstitutionGroup(elem, this.fSchemaVersion);
                for (int i = 0; i < subGroup.length; ++i) {
                    this.findElemInTable(type, subGroup[i], elemDeclHash);
                }
                continue;
            }
            this.checkExtraEDCRules(type, elem, grammarBucket, wcList);
        }
    }

    @Override
    public final void findElemInTable(XSComplexTypeDecl type, XSElementDecl elem, SymbolHash elemDeclHash) throws XMLSchemaException {
        XSElementDecl existingElem = this.findExistingElement(elem, elemDeclHash);
        if (existingElem == null || existingElem == elem) {
            return;
        }
        if (elem.fType != existingElem.fType) {
            throw new XMLSchemaException("cos-element-consistent", new Object[]{type.fName, elem.fName});
        }
        if (XS11TypeHelper.isTypeTablesComparable(elem.getTypeAlternatives(), existingElem.getTypeAlternatives()) && !this.isTypeTablesEquivalent(elem, existingElem)) {
            throw new XMLSchemaException("cos-element-consistent.4.b", new Object[]{type.fName, elem.fName});
        }
    }

    protected void preprocessModelGroupParticle(XSModelGroupImpl group, ArrayList wcList, Stack elemDeclStack) {
        for (int i = group.fParticleCount - 1; i >= 0; --i) {
            XSParticleDecl particle = group.fParticles[i];
            short pType = particle.fType;
            if (pType == 2) {
                XSWildcardDecl wc = (XSWildcardDecl)particle.fValue;
                if (wc.fProcessContents == 2) continue;
                wcList.add(wc);
                continue;
            }
            if (pType == 1) {
                elemDeclStack.push((XSElementDecl)particle.fValue);
                continue;
            }
            this.preprocessModelGroupParticle((XSModelGroupImpl)particle.fValue, wcList, elemDeclStack);
        }
    }

    private void checkExtraEDCRules(XSComplexTypeDecl type, XSElementDecl elem, XSGrammarBucket grammarBucket, ArrayList wcList) throws XMLSchemaException {
        for (int i = 0; i < wcList.size(); ++i) {
            XSElementDecl gElem;
            SchemaGrammar grammar;
            XSWildcardDecl wc = (XSWildcardDecl)wcList.get(i);
            if (!wc.allowName(elem.fTargetNamespace, elem.fName) || (grammar = grammarBucket.getGrammar(elem.fTargetNamespace)) == null || (gElem = grammar.getGlobalElementDecl(elem.fName)) == null || gElem == elem || !XS11TypeHelper.isTypeTablesComparable(elem.getTypeAlternatives(), gElem.getTypeAlternatives()) || this.isTypeTablesEquivalent(elem, gElem)) continue;
            throw new XMLSchemaException("cos-element-consistent.4.b", new Object[]{type.fName, elem.fName});
        }
    }

    @Override
    public final boolean isTypeTablesEquivalent(XSElementDecl elementDecl1, XSElementDecl elementDecl2) {
        XSTypeAlternativeImpl[] typeTable2;
        boolean typeTablesEquivalent = true;
        XSTypeAlternativeImpl[] typeTable1 = elementDecl1.getTypeAlternatives();
        if (typeTable1.length != (typeTable2 = elementDecl2.getTypeAlternatives()).length) {
            typeTablesEquivalent = false;
        }
        if (typeTablesEquivalent) {
            for (int typeAltIdx = 0; typeAltIdx < typeTable1.length; ++typeAltIdx) {
                XSTypeAlternativeImpl typeAlt1 = typeTable1[typeAltIdx];
                XSTypeAlternativeImpl typeAlt2 = typeTable2[typeAltIdx];
                if (this.isTypeAlternativesEquivalent(typeAlt1, typeAlt2)) continue;
                typeTablesEquivalent = false;
                break;
            }
        }
        if (typeTablesEquivalent && !elementDecl1.isTypeTableOK()) {
            typeTablesEquivalent = this.isTypeAlternativesEquivalent(elementDecl1.getDefaultTypeDefinition(), elementDecl2.getDefaultTypeDefinition());
        }
        return typeTablesEquivalent;
    }

    private boolean isTypeAlternativesEquivalent(XSTypeAlternativeImpl typeAlt1, XSTypeAlternativeImpl typeAlt2) {
        String defNamespace1 = typeAlt1.getXPathDefaultNamespace();
        String defNamespace2 = typeAlt2.getXPathDefaultNamespace();
        String testStr1 = typeAlt1.getTest() == null ? null : typeAlt1.getTest().toString();
        String testStr2 = typeAlt2.getTest() == null ? null : typeAlt2.getTest().toString();
        XSTypeDefinition typeDefn1 = typeAlt1.getTypeDefinition();
        XSTypeDefinition typeDefn2 = typeAlt2.getTypeDefinition();
        String baseURI1 = typeAlt1.getBaseURI();
        String baseURI2 = typeAlt2.getBaseURI();
        if (defNamespace1 != defNamespace2 || typeDefn1 != typeDefn2 || testStr1 == null && testStr2 != null || testStr1 != null && !testStr1.equals(testStr2) || baseURI1 == null && baseURI2 != null || baseURI1 != null && !baseURI1.equals(baseURI2)) {
            return false;
        }
        NamespaceSupport nsContext1 = typeAlt1.getNamespaceContext();
        NamespaceSupport nsContext2 = typeAlt2.getNamespaceContext();
        Enumeration prefixes1 = nsContext1.getAllPrefixes();
        Enumeration prefixes2 = nsContext2.getAllPrefixes();
        while (prefixes1.hasMoreElements()) {
            if (!prefixes2.hasMoreElements()) {
                return false;
            }
            String prefix1 = (String)prefixes1.nextElement();
            String prefix2 = (String)prefixes2.nextElement();
            if (nsContext1.getURI(prefix1) == nsContext2.getURI(prefix1) && nsContext1.getURI(prefix2) == nsContext2.getURI(prefix2)) continue;
            return false;
        }
        return !prefixes2.hasMoreElements();
    }

    @Override
    public boolean isSubsetOf(XSWildcardDecl wildcard, XSWildcardDecl superWildcard) {
        if (superWildcard == null) {
            return false;
        }
        if (superWildcard.fType != 1) {
            if (wildcard.fType == 3) {
                if (superWildcard.fType == 3 ? !this.subset2sets(wildcard.fNamespaceList, superWildcard.fNamespaceList) : !this.disjoint2sets(wildcard.fNamespaceList, superWildcard.fNamespaceList)) {
                    return false;
                }
            } else if (wildcard.fType == 2) {
                if (superWildcard.fType != 2 || !this.subset2sets(superWildcard.fNamespaceList, wildcard.fNamespaceList)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return !(superWildcard.fDisallowedDefined && !wildcard.fDisallowedDefined || superWildcard.fDisallowedSibling && wildcard.fDisallowedSibling) && (superWildcard.fDisallowedNamesList == null || !this.allowedNames(wildcard, superWildcard));
    }

    @Override
    public XSWildcardDecl performUnionWith(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard, short processContents) {
        if (otherWildcard == null) {
            return null;
        }
        XSWildcardDecl unionWildcard = new XSWildcardDecl();
        unionWildcard.fProcessContents = processContents;
        if (this.areSame(wildcard, otherWildcard)) {
            unionWildcard.fType = wildcard.fType;
            unionWildcard.fNamespaceList = wildcard.fNamespaceList;
        } else if (wildcard.fType == 1 || otherWildcard.fType == 1) {
            unionWildcard.fType = 1;
        } else if (wildcard.fType == 3 && otherWildcard.fType == 3) {
            unionWildcard.fType = (short)3;
            unionWildcard.fNamespaceList = this.union2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        } else if (wildcard.fType == 2 && otherWildcard.fType == 2) {
            String[] nsList = this.intersect2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
            if (nsList.length == 0) {
                unionWildcard.fType = 1;
            } else {
                unionWildcard.fType = (short)2;
                unionWildcard.fNamespaceList = nsList;
            }
        } else {
            String[] nsList;
            String[] stringArray = nsList = wildcard.fType == 2 ? this.difference2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList) : this.difference2sets(otherWildcard.fNamespaceList, wildcard.fNamespaceList);
            if (nsList.length == 0) {
                unionWildcard.fType = 1;
            } else {
                unionWildcard.fType = (short)2;
                unionWildcard.fNamespaceList = nsList;
            }
        }
        unionWildcard.fDisallowedNamesList = this.disallowedNamesUnion(wildcard, otherWildcard);
        unionWildcard.fDisallowedDefined = wildcard.fDisallowedDefined && otherWildcard.fDisallowedDefined;
        return unionWildcard;
    }

    @Override
    public XSWildcardDecl performIntersectionWith(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard, short processContents) {
        if (otherWildcard == null) {
            return null;
        }
        XSWildcardDecl intersectWildcard = new XSWildcardDecl();
        intersectWildcard.fProcessContents = processContents;
        if (this.areSame(wildcard, otherWildcard)) {
            intersectWildcard.fType = wildcard.fType;
            intersectWildcard.fNamespaceList = wildcard.fNamespaceList;
        } else if (wildcard.fType == 1 || otherWildcard.fType == 1) {
            XSWildcardDecl localWildcard = wildcard;
            if (wildcard.fType == 1) {
                localWildcard = otherWildcard;
            }
            intersectWildcard.fType = localWildcard.fType;
            intersectWildcard.fNamespaceList = localWildcard.fNamespaceList;
        } else if (wildcard.fType == 3 && otherWildcard.fType == 3) {
            intersectWildcard.fType = (short)3;
            intersectWildcard.fNamespaceList = this.intersect2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        } else if (wildcard.fType == 2 && otherWildcard.fType == 2) {
            intersectWildcard.fType = (short)2;
            intersectWildcard.fNamespaceList = this.union2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        } else {
            intersectWildcard.fType = (short)3;
            intersectWildcard.fNamespaceList = wildcard.fType == 2 ? this.difference2sets(otherWildcard.fNamespaceList, wildcard.fNamespaceList) : this.difference2sets(wildcard.fNamespaceList, otherWildcard.fNamespaceList);
        }
        intersectWildcard.fDisallowedNamesList = this.disallowedNamesIntersection(wildcard, otherWildcard);
        intersectWildcard.fDisallowedDefined = wildcard.fDisallowedDefined || otherWildcard.fDisallowedDefined;
        return intersectWildcard;
    }

    @Override
    boolean areSame(XSWildcardDecl wildcard, XSWildcardDecl otherWildcard) {
        if (wildcard.fType == otherWildcard.fType) {
            if (wildcard.fType == 1) {
                return true;
            }
            if (wildcard.fNamespaceList.length == otherWildcard.fNamespaceList.length) {
                for (int i = 0; i < wildcard.fNamespaceList.length; ++i) {
                    if (this.elementInSet(wildcard.fNamespaceList[i], otherWildcard.fNamespaceList)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private boolean allowedNames(XSWildcardDecl wildcard, XSWildcardDecl superWildcard) {
        for (int i = 0; i < superWildcard.fDisallowedNamesList.length; ++i) {
            if (!wildcard.allowQName(superWildcard.fDisallowedNamesList[i])) continue;
            return true;
        }
        return false;
    }

    private boolean disallowedNamespaces(XSWildcardDecl o1, XSWildcardDecl o2) {
        if (o2.fType == 1) {
            return false;
        }
        if (o1.fType == 1) {
            return true;
        }
        if (o1.fType == 3) {
            for (int i = 0; i < o1.fNamespaceList.length; ++i) {
                if (o2.allowNamespace(o1.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        if (o2.fType == 2) {
            for (int i = 0; i < o2.fNamespaceList.length; ++i) {
                if (!o1.allowNamespace(o2.fNamespaceList[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private String[] difference2sets(String[] set1, String[] set2) {
        String[] result = new String[set1.length];
        int count = 0;
        for (int i = 0; i < set1.length; ++i) {
            if (this.elementInSet(set1[i], set2)) continue;
            result[count++] = set1[i];
        }
        String[] result2 = new String[count];
        System.arraycopy(result, 0, result2, 0, count);
        return result2;
    }

    private QName[] disallowedNamesUnion(XSWildcardDecl one, XSWildcardDecl theOther) {
        int i;
        int len1 = one.fDisallowedNamesList == null ? 0 : one.fDisallowedNamesList.length;
        int len2 = theOther.fDisallowedNamesList == null ? 0 : theOther.fDisallowedNamesList.length;
        QName[] result = new QName[len1 + len2];
        int count = 0;
        for (i = 0; i < len1; ++i) {
            if (theOther.allowQName(one.fDisallowedNamesList[i])) continue;
            result[count++] = one.fDisallowedNamesList[i];
        }
        for (i = 0; i < len2; ++i) {
            if (one.allowQName(theOther.fDisallowedNamesList[i])) continue;
            result[count++] = theOther.fDisallowedNamesList[i];
        }
        QName[] result2 = new QName[count];
        System.arraycopy(result, 0, result2, 0, count);
        return result2;
    }

    private QName[] disallowedNamesIntersection(XSWildcardDecl one, XSWildcardDecl theOther) {
        int i;
        int len1 = one.fDisallowedNamesList == null ? 0 : one.fDisallowedNamesList.length;
        int len2 = theOther.fDisallowedNamesList == null ? 0 : theOther.fDisallowedNamesList.length;
        QName[] result = new QName[len1 + len2];
        int count = 0;
        for (i = 0; i < len1; ++i) {
            QName qname = one.fDisallowedNamesList[i];
            if (theOther.allowQName(qname)) {
                result[count++] = qname;
                continue;
            }
            if (!this.elementInSet(qname, theOther.fDisallowedNamesList)) continue;
            result[count++] = qname;
        }
        for (i = 0; i < len2; ++i) {
            if (!one.allowQName(theOther.fDisallowedNamesList[i])) continue;
            result[count++] = theOther.fDisallowedNamesList[i];
        }
        QName[] result2 = new QName[count];
        System.arraycopy(result, 0, result2, 0, count);
        return result2;
    }

    private boolean elementInSet(QName ele, QName[] eleSet) {
        boolean found = false;
        int length = eleSet == null ? 0 : eleSet.length;
        for (int i = 0; i < length && !found; ++i) {
            if (!ele.equals(eleSet[i])) continue;
            found = true;
        }
        return found;
    }

    @Override
    protected void groupSubsumption(XSParticleDecl dParticle, XSParticleDecl bParticle, XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter, String dName, SimpleLocator locator) {
        XSCMValidator cmd = cmBuilder.getContentModel(dParticle);
        XSCMValidator cmb = cmBuilder.getContentModel(bParticle);
        if (!new XS11CMRestriction(cmb, cmd, SGHandler, grammarBucket, cmBuilder, this).check()) {
            this.reportSchemaError(errorReporter, locator, "src-redefine.6.2.2", new Object[]{dName, ""});
        }
    }

    @Override
    protected void typeSubsumption(XSComplexTypeDecl dType, XSComplexTypeDecl bType, XSGrammarBucket grammarBucket, SubstitutionGroupHandler SGHandler, CMBuilder cmBuilder, XMLErrorReporter errorReporter, SimpleLocator locator) {
        XSCMValidator cmd = dType.getContentModel(cmBuilder);
        XSCMValidator cmb = bType.getContentModel(cmBuilder);
        if (!new XS11CMRestriction(cmb, cmd, SGHandler, grammarBucket, cmBuilder, this).check()) {
            this.reportSchemaError(errorReporter, locator, "derivation-ok-restriction.5.4.2", new Object[]{dType.fName});
        }
    }

    @Override
    protected final boolean checkEmptyFacets(XSSimpleType baseType) {
        return baseType.getMultiValueFacets() == XSObjectListImpl.EMPTY_LIST;
    }
}

