/*
 * Decompiled with CFR 0.152.
 */
package com.udojava.jmx.wrapper;

import com.udojava.jmx.wrapper.JMXBean;
import com.udojava.jmx.wrapper.JMXBeanAttribute;
import com.udojava.jmx.wrapper.JMXBeanOperation;
import com.udojava.jmx.wrapper.JMXBeanParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public class JMXBeanWrapper
implements DynamicMBean {
    public static final String BEAN_OPERATION_SORT = "com.udojava.jmx.wrapper.BEAN_OPERATION_SORT";
    private MBeanInfo beanInfo = null;
    private Object bean = null;
    private Map<String, BeanAttribute> beanAttributes = new HashMap<String, BeanAttribute>();
    private Map<String, String> operationMapping = new HashMap<String, String>();
    private ResourceBundle resourceBundle = null;
    private boolean sorted = false;

    public JMXBeanWrapper(Object bean2) throws SecurityException, IntrospectionException {
        this.bean = bean2;
        Class<?> beanClass = bean2.getClass();
        JMXBean jmxBean = beanClass.getAnnotation(JMXBean.class);
        if (jmxBean == null) {
            throw new IllegalArgumentException(beanClass.getName() + " not a JMXBean annotated class.");
        }
        String beanName = jmxBean.className().equals("") ? beanClass.getName() : jmxBean.className();
        String beanDescription = jmxBean.description();
        if (!jmxBean.resourceBundleName().equals("")) {
            this.resourceBundle = ResourceBundle.getBundle(jmxBean.resourceBundleName());
            if (this.resourceBundle != null && this.resourceBundle.containsKey(jmxBean.descriptionKey())) {
                beanDescription = this.resourceBundle.getString(jmxBean.descriptionKey());
            }
        }
        this.sorted = jmxBean.sorted();
        List<MBeanAttributeInfo> attributes = this.getBeanAttributeInfos(bean2);
        if (this.sorted) {
            Collections.sort(attributes, new Comparator<MBeanAttributeInfo>(){

                @Override
                public int compare(MBeanAttributeInfo o1, MBeanAttributeInfo o2) {
                    BeanAttribute a1 = (BeanAttribute)JMXBeanWrapper.this.beanAttributes.get(o1.getName());
                    BeanAttribute a2 = (BeanAttribute)JMXBeanWrapper.this.beanAttributes.get(o2.getName());
                    String s1 = a1.getSortValue().equals("") ? o1.getName() : a1.getSortValue();
                    String s2 = a2.getSortValue().equals("") ? o2.getName() : a2.getSortValue();
                    return s1.compareTo(s2);
                }
            });
        }
        List<MBeanOperationInfo> operations = this.getBeanOperationInfos(bean2);
        if (this.sorted) {
            Collections.sort(operations, new Comparator<MBeanOperationInfo>(){

                @Override
                public int compare(MBeanOperationInfo o1, MBeanOperationInfo o2) {
                    String s1 = (String)o1.getDescriptor().getFieldValue(JMXBeanWrapper.BEAN_OPERATION_SORT);
                    String s2 = (String)o2.getDescriptor().getFieldValue(JMXBeanWrapper.BEAN_OPERATION_SORT);
                    if ("".equals(s1)) {
                        s1 = o1.getName();
                    }
                    if ("".equals(s2)) {
                        s2 = o2.getName();
                    }
                    return s1.compareTo(s2);
                }
            });
        }
        this.beanInfo = new MBeanInfo(beanName, beanDescription, attributes.toArray(new MBeanAttributeInfo[0]), null, operations.toArray(new MBeanOperationInfo[0]), null);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        BeanAttribute att = this.beanAttributes.get(attribute);
        if (att == null) {
            throw new AttributeNotFoundException(attribute);
        }
        try {
            return att.getGetter().invoke(this.bean, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        BeanAttribute att = this.beanAttributes.get(attribute.getName());
        if (att == null) {
            throw new AttributeNotFoundException(attribute.getName());
        }
        try {
            att.getSetter().invoke(this.bean, attribute.getValue());
        }
        catch (Exception e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList result = new AttributeList();
        for (String name : attributes) {
            try {
                Object value = this.getAttribute(name);
                result.add(new Attribute(name, value));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList result = new AttributeList();
        for (Attribute att : attributes) {
            try {
                this.setAttribute(att);
                Attribute res = new Attribute(att.getName(), this.getAttribute(att.getName()));
                result.add(res);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private boolean signatureMatches(String[] signature, Method method) {
        if (signature != null && method.getParameterTypes().length != signature.length) {
            return false;
        }
        int i2 = 0;
        for (Class<?> clazz : method.getParameterTypes()) {
            if (clazz.getName().equals(signature[i2++])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String methodName = this.operationMapping.get(actionName);
        if (methodName != null) {
            try {
                for (Method method : this.bean.getClass().getMethods()) {
                    if (!method.getName().equals(methodName) || !this.signatureMatches(signature, method)) continue;
                    return method.invoke(this.bean, params);
                }
            }
            catch (Exception ex) {
                throw new ReflectionException(ex, "Can't convert signature for operation " + actionName);
            }
        }
        throw new MBeanException(new IllegalArgumentException("Operation not found: " + actionName + "(" + signature + ")"));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.beanInfo;
    }

    private List<MBeanOperationInfo> getBeanOperationInfos(Object bean2) {
        Class<?> beanClass = bean2.getClass();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Method method : beanClass.getMethods()) {
            JMXBeanOperation jmxBeanOperation = method.getAnnotation(JMXBeanOperation.class);
            if (jmxBeanOperation == null) continue;
            String name = jmxBeanOperation.name();
            String description = jmxBeanOperation.description();
            String sortValue = jmxBeanOperation.sortValue();
            if (this.resourceBundle != null) {
                if (!jmxBeanOperation.nameKey().equals("") && this.resourceBundle.containsKey(jmxBeanOperation.nameKey())) {
                    name = this.resourceBundle.getString(jmxBeanOperation.nameKey());
                }
                if (!jmxBeanOperation.descriptionKey().equals("") && this.resourceBundle.containsKey(jmxBeanOperation.descriptionKey())) {
                    description = this.resourceBundle.getString(jmxBeanOperation.descriptionKey());
                }
            }
            if ("".equals(name)) {
                name = method.getName();
            }
            int impact = 3;
            switch (jmxBeanOperation.impactType()) {
                case INFO: {
                    impact = 0;
                    break;
                }
                case ACTION: {
                    impact = 1;
                    break;
                }
                case ACTION_INFO: {
                    impact = 2;
                    break;
                }
                default: {
                    impact = 3;
                }
            }
            int counter = 0;
            ArrayList<MBeanParameterInfo> pInfos = new ArrayList<MBeanParameterInfo>();
            Class<?>[] classes = method.getParameterTypes();
            Annotation[][] paramAnnotations = method.getParameterAnnotations();
            for (Class<?> clazz : classes) {
                String paramName = "param" + ++counter;
                String paramType = clazz.getName();
                String paramDescription = "";
                if (paramAnnotations[counter - 1].length > 0) {
                    for (Annotation a : paramAnnotations[counter - 1]) {
                        if (!(a instanceof JMXBeanParameter)) continue;
                        JMXBeanParameter jmxBeanParameter = (JMXBeanParameter)a;
                        paramDescription = jmxBeanParameter.description();
                        if (!"".equals(jmxBeanParameter.name())) {
                            paramName = jmxBeanParameter.name();
                        }
                        if (this.resourceBundle == null) continue;
                        if (!jmxBeanParameter.nameKey().equals("") && this.resourceBundle.containsKey(jmxBeanParameter.nameKey())) {
                            paramName = this.resourceBundle.getString(jmxBeanParameter.nameKey());
                        }
                        if (jmxBeanParameter.descriptionKey().equals("") || !this.resourceBundle.containsKey(jmxBeanParameter.descriptionKey())) continue;
                        paramDescription = this.resourceBundle.getString(jmxBeanParameter.descriptionKey());
                    }
                }
                MBeanParameterInfo pInfo = new MBeanParameterInfo(paramName, paramType, paramDescription);
                pInfos.add(pInfo);
            }
            HashMap<String, String> descriptorValues = new HashMap<String, String>();
            descriptorValues.put(BEAN_OPERATION_SORT, sortValue);
            ImmutableDescriptor desc = new ImmutableDescriptor(descriptorValues);
            MBeanOperationInfo info = new MBeanOperationInfo(name, description, pInfos.toArray(new MBeanParameterInfo[0]), method.getReturnType().getName(), impact, desc);
            this.operationMapping.put(name, method.getName());
            operations.add(info);
        }
        return operations;
    }

    private List<MBeanAttributeInfo> getBeanAttributeInfos(Object bean2) throws IntrospectionException {
        Class<?> beanClass = bean2.getClass();
        for (Method method : beanClass.getMethods()) {
            BeanAttribute att;
            JMXBeanAttribute jmxBeanAttribute = method.getAnnotation(JMXBeanAttribute.class);
            if (jmxBeanAttribute == null) continue;
            String description = jmxBeanAttribute.description();
            String name = jmxBeanAttribute.name();
            String sortValue = jmxBeanAttribute.sortValue();
            if (this.resourceBundle != null) {
                if (!jmxBeanAttribute.nameKey().equals("") && this.resourceBundle.containsKey(jmxBeanAttribute.nameKey())) {
                    name = this.resourceBundle.getString(jmxBeanAttribute.nameKey());
                }
                if (!jmxBeanAttribute.descriptionKey().equals("") && this.resourceBundle.containsKey(jmxBeanAttribute.descriptionKey())) {
                    description = this.resourceBundle.getString(jmxBeanAttribute.descriptionKey());
                }
            }
            if (method.getName().startsWith("get") || method.getName().startsWith("is")) {
                if ("".equals(name)) {
                    name = method.getName().startsWith("get") ? method.getName().substring(3) : method.getName().substring(2);
                    name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                }
                if ((att = this.beanAttributes.get(name)) == null) {
                    this.beanAttributes.put(name, new BeanAttribute(method, null, description, sortValue));
                    continue;
                }
                att.setGetter(method);
                if (!"".equals(att.getDescription())) continue;
                att.setDescription(description);
                continue;
            }
            if (!method.getName().startsWith("set")) continue;
            if ("".equals(name)) {
                name = method.getName().substring(3);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            if ((att = this.beanAttributes.get(name)) == null) {
                this.beanAttributes.put(name, new BeanAttribute(null, method, description, sortValue));
                continue;
            }
            att.setSetter(method);
            if (!"".equals(att.getDescription())) continue;
            att.setDescription(description);
        }
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        for (Map.Entry<String, BeanAttribute> entry : this.beanAttributes.entrySet()) {
            MBeanAttributeInfo info = new MBeanAttributeInfo(entry.getKey(), entry.getValue().getDescription(), entry.getValue().getGetter(), entry.getValue().getSetter());
            attributes.add(info);
        }
        return attributes;
    }

    public String toString() {
        return this.bean.toString() + ":" + this.beanInfo.toString();
    }

    private class BeanAttribute {
        private Method getter;
        private Method setter;
        private String description;
        private String sortValue;

        public BeanAttribute(Method getter, Method setter, String description, String sortValue) {
            this.setGetter(getter);
            this.setSetter(setter);
            this.setDescription(description);
            this.setSortValue(sortValue);
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public void setGetter(Method method) {
            this.getter = method;
        }

        public void setSetter(Method method) {
            this.setter = method;
        }

        public String getSortValue() {
            return this.sortValue;
        }

        public void setSortValue(String sortValue) {
            this.sortValue = sortValue;
        }
    }
}

