/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.projectset.data;

import com.openexchange.projectset.data.Repository;
import com.openexchange.projectset.data.RepositoryType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.BuildException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lcom/openexchange/projectset/data/GitRepository;", "Lcom/openexchange/projectset/data/Repository;", "remote", "", "branch", "projectName", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "getRemote", "repositoryType", "Lcom/openexchange/projectset/data/RepositoryType;", "getRepositoryType", "()Lcom/openexchange/projectset/data/RepositoryType;", "Companion", "projectset"})
public final class GitRepository
extends Repository {
    @NotNull
    private final String remote;
    @NotNull
    private final String branch;
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public RepositoryType getRepositoryType() {
        return RepositoryType.Git;
    }

    @NotNull
    public final String getRemote() {
        return this.remote;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    public GitRepository(@NotNull String remote, @NotNull String branch, @NotNull String projectName) {
        Intrinsics.checkParameterIsNotNull((Object)remote, (String)"remote");
        Intrinsics.checkParameterIsNotNull((Object)branch, (String)"branch");
        Intrinsics.checkParameterIsNotNull((Object)projectName, (String)"projectName");
        super(projectName);
        this.remote = remote;
        this.branch = branch;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/openexchange/projectset/data/GitRepository$Companion;", "", "()V", "parseGitReference", "Lcom/openexchange/projectset/data/Repository;", "reference", "", "projectset"})
    public static final class Companion {
        @NotNull
        public final Repository parseGitReference(@NotNull String reference) {
            Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
            List parts = StringsKt.split$default((CharSequence)reference, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            if (parts.size() != 4) {
                throw (Throwable)new BuildException("Unknown number of Git reference definition parts.");
            }
            if (Intrinsics.areEqual((Object)((String)parts.get(0)), (Object)"1.0") ^ true) {
                throw (Throwable)new BuildException("Unknown CVS reference version " + (String)parts.get(0));
            }
            return new GitRepository((String)parts.get(1), (String)parts.get(2), (String)parts.get(3));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

