/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.CompactSerializationConfigAccessor;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.impl.FieldOperations;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactInternalGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.CompactSerializableRegistration;
import com.hazelcast.internal.serialization.impl.compact.Compactable;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactReader;
import com.hazelcast.internal.serialization.impl.compact.DefaultCompactWriter;
import com.hazelcast.internal.serialization.impl.compact.FieldDescriptor;
import com.hazelcast.internal.serialization.impl.compact.ReflectiveCompactSerializer;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.SchemaService;
import com.hazelcast.internal.serialization.impl.compact.SchemaWriter;
import com.hazelcast.internal.serialization.impl.compact.SerializingGenericRecordBuilder;
import com.hazelcast.internal.serialization.impl.compact.SerializingGenericRecordCloner;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class CompactStreamSerializer
implements StreamSerializer<Object> {
    private final Map<Class, CompactSerializableRegistration> classToRegistrationMap = new ConcurrentHashMap<Class, CompactSerializableRegistration>();
    private final Map<String, CompactSerializableRegistration> typeNameToRegistrationMap = new ConcurrentHashMap<String, CompactSerializableRegistration>();
    private final Map<Class, Schema> classToSchemaMap = new ConcurrentHashMap<Class, Schema>();
    private final ReflectiveCompactSerializer reflectiveSerializer = new ReflectiveCompactSerializer();
    private final SchemaService schemaService;
    private final ManagedContext managedContext;
    private final ClassLoader classLoader;
    private final Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc;
    private final Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier;
    private final boolean isEnabled;

    public CompactStreamSerializer(CompactSerializationConfig compactSerializationConfig, ManagedContext managedContext, SchemaService schemaService, ClassLoader classLoader, Function<byte[], BufferObjectDataInput> bufferObjectDataInputFunc, Supplier<BufferObjectDataOutput> bufferObjectDataOutputSupplier) {
        this.managedContext = managedContext;
        this.schemaService = schemaService;
        this.bufferObjectDataInputFunc = bufferObjectDataInputFunc;
        this.bufferObjectDataOutputSupplier = bufferObjectDataOutputSupplier;
        this.classLoader = classLoader;
        this.isEnabled = compactSerializationConfig.isEnabled();
        this.registerConfiguredSerializers(compactSerializationConfig);
        this.registerConfiguredNamedSerializers(compactSerializationConfig);
    }

    public boolean isRegisteredAsCompact(Class clazz) {
        return this.classToRegistrationMap.containsKey(clazz);
    }

    @Override
    public int getTypeId() {
        return -55;
    }

    public GenericRecordBuilder createGenericRecordBuilder(Schema schema) {
        return new SerializingGenericRecordBuilder(this, schema, this.bufferObjectDataInputFunc, this.bufferObjectDataOutputSupplier);
    }

    public GenericRecordBuilder createGenericRecordCloner(Schema schema, CompactInternalGenericRecord record) {
        return new SerializingGenericRecordCloner(this, schema, record, this.bufferObjectDataInputFunc, this.bufferObjectDataOutputSupplier);
    }

    @Override
    public void write(ObjectDataOutput out, Object o) throws IOException {
        assert (out instanceof BufferObjectDataOutput);
        BufferObjectDataOutput bufferObjectDataOutput = (BufferObjectDataOutput)out;
        this.write(bufferObjectDataOutput, o, false);
    }

    void write(BufferObjectDataOutput out, Object o, boolean includeSchemaOnBinary) throws IOException {
        if (o instanceof CompactGenericRecord) {
            this.writeGenericRecord(out, (CompactGenericRecord)o, includeSchemaOnBinary);
        } else {
            this.writeObject(out, o, includeSchemaOnBinary);
        }
    }

    void writeGenericRecord(BufferObjectDataOutput output, CompactGenericRecord record, boolean includeSchemaOnBinary) throws IOException {
        Schema schema = record.getSchema();
        this.putToSchemaService(includeSchemaOnBinary, schema);
        this.writeSchema(output, includeSchemaOnBinary, schema);
        DefaultCompactWriter writer = new DefaultCompactWriter(this, output, schema, includeSchemaOnBinary);
        Collection<FieldDescriptor> fields = schema.getFields();
        for (FieldDescriptor fieldDescriptor : fields) {
            String fieldName = fieldDescriptor.getFieldName();
            FieldType fieldType = fieldDescriptor.getType();
            FieldOperations.fieldOperations(fieldType).writeFieldFromRecordToWriter(writer, record, fieldName);
        }
        writer.end();
    }

    private void putToSchemaService(boolean includeSchemaOnBinary, Schema schema) {
        if (includeSchemaOnBinary) {
            this.schemaService.putLocal(schema);
        } else {
            this.schemaService.put(schema);
        }
    }

    public void writeObject(BufferObjectDataOutput out, Object o, boolean includeSchemaOnBinary) throws IOException {
        CompactWriter writer;
        CompactSerializableRegistration registration = this.getOrCreateRegistration(o);
        Class<?> aClass = o.getClass();
        Schema schema = this.classToSchemaMap.get(aClass);
        if (schema == null) {
            writer = new SchemaWriter(registration.getTypeName());
            registration.getSerializer().write(writer, o);
            schema = ((SchemaWriter)writer).build();
            this.putToSchemaService(includeSchemaOnBinary, schema);
            this.classToSchemaMap.put(aClass, schema);
        }
        this.writeSchema(out, includeSchemaOnBinary, schema);
        writer = new DefaultCompactWriter(this, out, schema, includeSchemaOnBinary);
        registration.getSerializer().write(writer, o);
        ((DefaultCompactWriter)writer).end();
    }

    private void writeSchema(BufferObjectDataOutput out, boolean includeSchemaOnBinary, Schema schema) throws IOException {
        out.writeLong(schema.getSchemaId());
        if (includeSchemaOnBinary) {
            int sizeOfSchemaPosition = out.position();
            out.writeInt(0);
            int schemaBeginPos = out.position();
            out.writeObject(schema);
            int schemaEndPosition = out.position();
            out.writeInt(sizeOfSchemaPosition, schemaEndPosition - schemaBeginPos);
        }
    }

    @Override
    public Object read(@Nonnull ObjectDataInput in) throws IOException {
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        return this.read(input, false);
    }

    Object read(BufferObjectDataInput input, boolean schemaIncludedInBinary) throws IOException {
        Schema schema = this.getOrReadSchema(input, schemaIncludedInBinary);
        CompactSerializableRegistration registration = this.getOrCreateRegistration(schema.getTypeName());
        if (registration == null) {
            return new DefaultCompactReader(this, input, schema, null, schemaIncludedInBinary);
        }
        DefaultCompactReader genericRecord = new DefaultCompactReader(this, input, schema, registration.getClazz(), schemaIncludedInBinary);
        Object object = registration.getSerializer().read(genericRecord);
        return this.managedContext != null ? this.managedContext.initialize(object) : object;
    }

    private Schema getOrReadSchema(ObjectDataInput input, boolean schemaIncludedInBinary) throws IOException {
        long schemaId = input.readLong();
        Schema schema = this.schemaService.get(schemaId);
        if (schema != null) {
            if (schemaIncludedInBinary) {
                int sizeOfSchema = input.readInt();
                input.skipBytes(sizeOfSchema);
            }
            return schema;
        }
        if (schemaIncludedInBinary) {
            input.readInt();
            schema = (Schema)input.readObject();
            long incomingSchemaId = schema.getSchemaId();
            if (schemaId != incomingSchemaId) {
                throw new HazelcastSerializationException("Invalid schema id found. Expected " + schemaId + ", actual " + incomingSchemaId + " for schema " + schema);
            }
            this.schemaService.putLocal(schema);
            return schema;
        }
        throw new HazelcastSerializationException("The schema can not be found with id " + schemaId);
    }

    private CompactSerializableRegistration getOrCreateRegistration(Object object) {
        return this.classToRegistrationMap.computeIfAbsent(object.getClass(), aClass -> {
            CompactSerializer<Object> serializer = object instanceof Compactable ? ((Compactable)object).getCompactSerializer() : this.reflectiveSerializer;
            return new CompactSerializableRegistration((Class)aClass, aClass.getName(), serializer);
        });
    }

    private CompactSerializableRegistration getOrCreateRegistration(String typeName) {
        return this.typeNameToRegistrationMap.computeIfAbsent(typeName, s -> {
            Class<?> clazz;
            try {
                clazz = ClassLoaderUtil.loadClass(this.classLoader, typeName);
            }
            catch (Exception e) {
                return null;
            }
            try {
                Object object = ClassLoaderUtil.newInstance(clazz.getClassLoader(), clazz);
                return this.getOrCreateRegistration(object);
            }
            catch (Exception e) {
                throw new HazelcastSerializationException("Class " + clazz + " must have an empty constructor", e);
            }
        });
    }

    public GenericRecord readGenericRecord(ObjectDataInput in, boolean schemaIncludedInBinary) throws IOException {
        Schema schema = this.getOrReadSchema(in, schemaIncludedInBinary);
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        return new DefaultCompactReader(this, input, schema, null, schemaIncludedInBinary);
    }

    public InternalGenericRecord readAsInternalGenericRecord(ObjectDataInput input) throws IOException {
        return (InternalGenericRecord)this.readGenericRecord(input, false);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void registerConfiguredSerializers(CompactSerializationConfig compactSerializationConfig) {
        Map<String, TriTuple<Class, String, CompactSerializer>> registries = compactSerializationConfig.getRegistries();
        for (TriTuple<Class, String, CompactSerializer> registry : registries.values()) {
            Class clazz = (Class)registry.element1;
            String typeName = (String)registry.element2;
            CompactSerializer<Object> serializer = (CompactSerializer<Object>)registry.element3;
            serializer = serializer == null ? this.reflectiveSerializer : serializer;
            CompactSerializableRegistration registration = new CompactSerializableRegistration(clazz, typeName, serializer);
            this.classToRegistrationMap.put(clazz, registration);
            this.typeNameToRegistrationMap.put(typeName, registration);
        }
    }

    private void registerConfiguredNamedSerializers(CompactSerializationConfig compactSerializationConfig) {
        Map<String, TriTuple<String, String, String>> namedRegistries = CompactSerializationConfigAccessor.getNamedRegistries(compactSerializationConfig);
        for (TriTuple<String, String, String> registry : namedRegistries.values()) {
            Class<?> clazz;
            CompactSerializer<Object> serializer;
            String className = (String)registry.element1;
            String typeName = (String)registry.element2;
            String serializerClassName = (String)registry.element3;
            if (serializerClassName != null) {
                try {
                    serializer = (CompactSerializer)ClassLoaderUtil.newInstance(this.classLoader, serializerClassName);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot create an instance of " + serializerClassName);
                }
            } else {
                serializer = this.reflectiveSerializer;
            }
            try {
                clazz = ClassLoaderUtil.loadClass(this.classLoader, className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot load the class " + className);
            }
            CompactSerializableRegistration registration = new CompactSerializableRegistration(clazz, typeName, serializer);
            this.classToRegistrationMap.put(clazz, registration);
            this.typeNameToRegistrationMap.put(typeName, registration);
        }
    }
}

