/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.transaction.impl.xa;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.impl.xa.ClearRemoteTransactionBackupOperation;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.transaction.impl.xa.XAService;
import java.io.IOException;

public class ClearRemoteTransactionOperation
extends Operation
implements BackupAwareOperation {
    private Data xidData;
    private transient SerializableXID xid;

    public ClearRemoteTransactionOperation() {
    }

    public ClearRemoteTransactionOperation(Data xidData) {
        this.xidData = xidData;
    }

    @Override
    public void beforeRun() throws Exception {
        this.xid = (SerializableXID)this.getNodeEngine().toObject(this.xidData);
    }

    @Override
    public void run() throws Exception {
        XAService xaService = (XAService)this.getService();
        xaService.removeTransactions(this.xid);
    }

    @Override
    public void afterRun() throws Exception {
    }

    @Override
    public boolean returnsResponse() {
        return true;
    }

    @Override
    public Object getResponse() {
        return null;
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public int getSyncBackupCount() {
        return 0;
    }

    @Override
    public int getAsyncBackupCount() {
        return 1;
    }

    @Override
    public Operation getBackupOperation() {
        return new ClearRemoteTransactionBackupOperation(this.xidData);
    }

    @Override
    public String getServiceName() {
        return "hz:impl:xaService";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeData(this.xidData);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.xidData = in.readData();
    }
}

