/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node.io;

import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.ZeroInputPlanNode;
import com.hazelcast.sql.impl.plan.node.io.EdgeAwarePlanNode;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class ReceivePlanNode
extends ZeroInputPlanNode
implements EdgeAwarePlanNode,
IdentifiedDataSerializable {
    private int edgeId;
    private List<QueryDataType> fieldTypes;

    public ReceivePlanNode() {
    }

    public ReceivePlanNode(int id, int edgeId, List<QueryDataType> fieldTypes) {
        super(id);
        this.edgeId = edgeId;
        this.fieldTypes = fieldTypes;
    }

    @Override
    public int getEdgeId() {
        return this.edgeId;
    }

    @Override
    public boolean isSender() {
        return false;
    }

    @Override
    public void visit(PlanNodeVisitor visitor) {
        visitor.onReceiveNode(this);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 16;
    }

    @Override
    public PlanNodeSchema getSchema0() {
        return new PlanNodeSchema(this.fieldTypes);
    }

    @Override
    public void writeData0(ObjectDataOutput out) throws IOException {
        out.writeInt(this.edgeId);
        SerializationUtil.writeList(this.fieldTypes, out);
    }

    @Override
    public void readData0(ObjectDataInput in) throws IOException {
        this.edgeId = in.readInt();
        this.fieldTypes = SerializationUtil.readList(in);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.edgeId, this.fieldTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceivePlanNode that = (ReceivePlanNode)o;
        return this.id == that.id && this.edgeId == that.edgeId && this.fieldTypes.equals(that.fieldTypes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", edgeId=" + this.edgeId + ", fieldTypes=" + this.fieldTypes + '}';
    }
}

