/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.util.ConversionUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastObjectType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTemporalType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;

public final class HazelcastTypeFactory
extends SqlTypeFactoryImpl {
    public static final HazelcastTypeFactory INSTANCE = new HazelcastTypeFactory();

    private HazelcastTypeFactory() {
        super(HazelcastTypeSystem.INSTANCE);
    }

    public RelDataType createSqlType(SqlTypeName typeName, boolean nullable) {
        RelDataType type = this.createSqlType(typeName);
        assert (!type.isNullable());
        if (nullable) {
            type = this.createTypeWithNullability(type, true);
        }
        return type;
    }

    @Override
    public Charset getDefaultCharset() {
        return Charset.forName(ConversionUtil.NATIVE_UTF16_CHARSET_NAME);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName);
        }
        return type;
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName, precision);
        }
        return type;
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.createType(typeName);
        if (type == null) {
            type = super.createSqlType(typeName, precision, scale);
        }
        return type;
    }

    @Nullable
    private RelDataType createType(SqlTypeName typeName) {
        if (typeName == SqlTypeName.DECIMAL) {
            return this.createDecimal();
        }
        if (typeName == SqlTypeName.ANY) {
            return HazelcastObjectType.INSTANCE;
        }
        if (typeName == SqlTypeName.TIME) {
            return HazelcastTemporalType.TIME;
        }
        if (typeName == SqlTypeName.TIMESTAMP) {
            return HazelcastTemporalType.TIMESTAMP;
        }
        if (typeName == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return HazelcastTemporalType.TIMESTAMP_WITH_TIME_ZONE;
        }
        if (HazelcastIntegerType.supports(typeName)) {
            return HazelcastIntegerType.of(typeName);
        }
        return null;
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        if (HazelcastIntegerType.supports(type.getSqlTypeName())) {
            return HazelcastIntegerType.of(type, nullable);
        }
        if (type.getSqlTypeName() == SqlTypeName.ANY) {
            return nullable ? HazelcastObjectType.NULLABLE_INSTANCE : HazelcastObjectType.INSTANCE;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIME) {
            return nullable ? HazelcastTemporalType.TIME_NULLABLE : HazelcastTemporalType.TIME;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIMESTAMP) {
            return nullable ? HazelcastTemporalType.TIMESTAMP_NULLABLE : HazelcastTemporalType.TIMESTAMP;
        }
        if (type.getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
            return nullable ? HazelcastTemporalType.TIMESTAMP_WITH_TIME_ZONE_NULLABLE : HazelcastTemporalType.TIMESTAMP_WITH_TIME_ZONE;
        }
        return super.createTypeWithNullability(type, nullable);
    }

    @Override
    public RelDataType leastRestrictive(List<RelDataType> types) {
        RelDataType selected = super.leastRestrictive(types);
        if (selected == null) {
            return null;
        }
        SqlTypeName selectedTypeName = selected.getSqlTypeName();
        if (HazelcastIntegerType.supports(selectedTypeName)) {
            return HazelcastIntegerType.leastRestrictive(selected, types);
        }
        if (selectedTypeName == SqlTypeName.DOUBLE) {
            boolean seenDouble = false;
            boolean seenReal = false;
            for (RelDataType type : types) {
                if (type.getSqlTypeName() == SqlTypeName.DOUBLE) {
                    seenDouble = true;
                    break;
                }
                if (type.getSqlTypeName() != SqlTypeName.REAL) continue;
                seenReal = true;
            }
            if (!seenDouble && seenReal) {
                selected = this.createSqlType(SqlTypeName.REAL, selected.isNullable());
            }
        }
        return selected;
    }

    private RelDataType createDecimal() {
        return super.createSqlType(SqlTypeName.DECIMAL, 38, 38);
    }
}

