/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.com.google.common.base.Preconditions;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlCharStringLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlFunctionCategory;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlOperatorBinding;
import com.hazelcast.org.apache.calcite.sql.SqlUtil;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.fun.SqlMonotonicUnaryFunction;
import com.hazelcast.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.org.apache.calcite.sql.type.OperandTypes;
import com.hazelcast.org.apache.calcite.sql.type.ReturnTypes;
import com.hazelcast.org.apache.calcite.sql.validate.SqlMonotonicity;

public class SqlFloorFunction
extends SqlMonotonicUnaryFunction {
    public SqlFloorFunction(SqlKind kind) {
        super(kind.name(), kind, ReturnTypes.ARG0_OR_EXACT_NO_SCALE, null, OperandTypes.or(OperandTypes.NUMERIC_OR_INTERVAL, OperandTypes.sequence("'" + (Object)((Object)kind) + "(<DATE> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIME> TO <TIME_UNIT>)'\n'" + (Object)((Object)kind) + "(<TIMESTAMP> TO <TIME_UNIT>)'", OperandTypes.DATETIME, OperandTypes.ANY)), SqlFunctionCategory.NUMERIC);
        Preconditions.checkArgument(kind == SqlKind.FLOOR || kind == SqlKind.CEIL);
    }

    @Override
    public SqlMonotonicity getMonotonicity(SqlOperatorBinding call) {
        return call.getOperandMonotonicity(0).unstrict();
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlWriter.Frame frame = writer.startFunCall(this.getName());
        if (call.operandCount() == 2) {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 100);
            writer.sep("TO");
            ((SqlNode)call.operand(1)).unparse(writer, 100, 0);
        } else {
            ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
        }
        writer.endFunCall(frame);
    }

    public static SqlCall replaceTimeUnitOperand(SqlCall call, String literal, SqlParserPos pos) {
        SqlCharStringLiteral literalNode = SqlLiteral.createCharString(literal, null, pos);
        return call.getOperator().createCall(call.getFunctionQuantifier(), pos, call.getOperandList().get(0), literalNode);
    }

    public static void unparseDatetimeFunction(SqlWriter writer, SqlCall call, String funName, Boolean datetimeFirst) {
        SqlCall call1;
        SqlFunction func = new SqlFunction(funName, SqlKind.OTHER_FUNCTION, ReturnTypes.ARG0_NULLABLE_VARYING, null, null, SqlFunctionCategory.STRING);
        if (datetimeFirst.booleanValue()) {
            call1 = call;
        } else {
            Object op1 = call.operand(0);
            Object op2 = call.operand(1);
            call1 = call.getOperator().createCall(call.getParserPosition(), new SqlNode[]{op2, op1});
        }
        SqlUtil.unparseFunctionSyntax(func, writer, call1);
    }
}

