/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.rel.metadata;

import com.hazelcast.com.google.common.collect.HashBasedTable;
import com.hazelcast.com.google.common.collect.Table;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import com.hazelcast.org.apache.calcite.rel.metadata.Metadata;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataDef;
import com.hazelcast.org.apache.calcite.rel.metadata.MetadataHandler;
import com.hazelcast.org.apache.calcite.rel.metadata.RelMetadataQuery;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Map;

public class RelMetadataQueryBase {
    public final Table<RelNode, List, Object> map = HashBasedTable.create();
    public final JaninoRelMetadataProvider metadataProvider;
    public static final ThreadLocal<JaninoRelMetadataProvider> THREAD_PROVIDERS = new ThreadLocal();

    protected RelMetadataQueryBase(JaninoRelMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected static <H> H initialHandler(Class<H> handlerClass) {
        return handlerClass.cast(Proxy.newProxyInstance(RelMetadataQuery.class.getClassLoader(), new Class[]{handlerClass}, (proxy, method, args) -> {
            RelNode r = (RelNode)args[0];
            throw new JaninoRelMetadataProvider.NoHandler(r.getClass());
        }));
    }

    protected <M extends Metadata, H extends MetadataHandler<M>> H revise(Class<? extends RelNode> class_, MetadataDef<M> def) {
        return this.metadataProvider.revise(class_, def);
    }

    public boolean clearCache(RelNode rel) {
        Map<List, Object> row = this.map.row(rel);
        if (row.isEmpty()) {
            return false;
        }
        row.clear();
        return true;
    }
}

