/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.hazelcast.ssl.osgi;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import com.hazelcast.ssl.HazellcastSSLContextFactoryProviderImpl;
import com.openexchange.hazelcast.ssl.HazelcastSSLContextFactoryProvider;

/**
 * {@link HazelcastSSLFactoryActivator}
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 * @since v7.10.6
 */
public class HazelcastSSLFactoryActivator implements BundleActivator {

    private ServiceRegistration<HazelcastSSLContextFactoryProvider> factoryProviderRegistration;

    /**
     * Initializes a new {@link HazelcastSSLFactoryActivator}.
     */
    public HazelcastSSLFactoryActivator() {
        super();
    }

    @Override
    public synchronized void start(BundleContext context) throws Exception {
        HazelcastSSLContextFactoryProvider factoryProvider = new HazellcastSSLContextFactoryProviderImpl();
        factoryProviderRegistration = context.registerService(HazelcastSSLContextFactoryProvider.class, factoryProvider, null);
    }

    @Override
    public synchronized void stop(BundleContext context) throws Exception {
        ServiceRegistration<HazelcastSSLContextFactoryProvider> factoryProviderRegistration = this.factoryProviderRegistration;
        if (factoryProviderRegistration != null) {
            this.factoryProviderRegistration = null;
            factoryProviderRegistration.unregister();
        }
    }

}
