/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfoSupplier;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.NullQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheEndToEndConstructor;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheFactory;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRequest;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberListener;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.query.Predicate;
import com.hazelcast.util.ExceptionUtil;

public abstract class AbstractQueryCacheEndToEndConstructor
implements QueryCacheEndToEndConstructor {
    protected static final int OPERATION_WAIT_TIMEOUT_MINUTES = 5;
    protected final String mapName;
    protected final QueryCacheRequest request;
    protected final QueryCacheContext context;
    protected final SubscriberContext subscriberContext;
    protected final ILogger logger = Logger.getLogger(this.getClass());
    protected Predicate predicate;
    protected boolean includeValue;
    protected InternalQueryCache queryCache;

    public AbstractQueryCacheEndToEndConstructor(QueryCacheRequest request) {
        this.request = request;
        this.mapName = request.getMapName();
        this.context = request.getContext();
        this.subscriberContext = this.context.getSubscriberContext();
    }

    @Override
    public final void createSubscriberAccumulator(AccumulatorInfo info) {
        QueryCacheEventService eventService = this.context.getQueryCacheEventService();
        SubscriberListener listener = new SubscriberListener(this.context, info);
        eventService.listenPublisher(info.getMapName(), info.getCacheName(), listener);
    }

    @Override
    public final InternalQueryCache createNew(String arg) {
        try {
            QueryCacheConfig queryCacheConfig = this.initQueryCacheConfig(this.request);
            if (queryCacheConfig == null) {
                return NullQueryCache.NULL_QUERY_CACHE;
            }
            this.queryCache = this.createUnderlyingQueryCache(this.request);
            this.addListener(this.request);
            AccumulatorInfo info = AccumulatorInfo.createAccumulatorInfo(queryCacheConfig, this.mapName, this.request.getCacheName(), this.predicate);
            this.addInfoToSubscriberContext(info);
            info.setPublishable(true);
            this.createSubscriberAccumulator(info);
            this.createPublisherAccumulator(info);
        }
        catch (Throwable throwable) {
            this.removeQueryCacheConfig(this.mapName, this.request.getUserGivenCacheName());
            throw ExceptionUtil.rethrow(throwable);
        }
        return this.queryCache;
    }

    private InternalQueryCache createUnderlyingQueryCache(QueryCacheRequest request) {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        QueryCacheFactory queryCacheFactory = subscriberContext.getQueryCacheFactory();
        return queryCacheFactory.create(request);
    }

    private void addInfoToSubscriberContext(AccumulatorInfo info) {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        AccumulatorInfoSupplier accumulatorInfoSupplier = subscriberContext.getAccumulatorInfoSupplier();
        accumulatorInfoSupplier.putIfAbsent(info.getMapName(), info.getCacheName(), info);
    }

    private String addListener(QueryCacheRequest request) {
        MapListener listener = request.getListener();
        if (listener == null) {
            return null;
        }
        QueryCacheEventService eventService = this.subscriberContext.getEventService();
        return eventService.addListener(request.getMapName(), request.getCacheName(), listener);
    }

    public String getCacheName() {
        return this.request.getCacheName();
    }

    protected Object toObject(Object data) {
        return this.context.toObject(data);
    }

    protected QueryCacheConfig initQueryCacheConfig(QueryCacheRequest request) {
        QueryCacheConfig queryCacheConfig;
        Predicate predicate = request.getPredicate();
        if (predicate == null) {
            queryCacheConfig = this.getOrNullQueryCacheConfig(this.mapName, request.getUserGivenCacheName());
        } else {
            queryCacheConfig = this.getOrCreateQueryCacheConfig(this.mapName, request.getUserGivenCacheName());
            queryCacheConfig.setIncludeValue(request.isIncludeValue());
            queryCacheConfig.getPredicateConfig().setImplementation(predicate);
        }
        if (queryCacheConfig == null) {
            return null;
        }
        this.includeValue = queryCacheConfig.isIncludeValue();
        this.predicate = queryCacheConfig.getPredicateConfig().getImplementation();
        return queryCacheConfig;
    }

    private QueryCacheConfig getOrCreateQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfigurator queryCacheConfigurator = this.subscriberContext.geQueryCacheConfigurator();
        return queryCacheConfigurator.getOrCreateConfiguration(mapName, cacheName);
    }

    private QueryCacheConfig getOrNullQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfigurator queryCacheConfigurator = this.subscriberContext.geQueryCacheConfigurator();
        return queryCacheConfigurator.getOrNull(mapName, cacheName);
    }

    private void removeQueryCacheConfig(String mapName, String cacheName) {
        QueryCacheConfigurator queryCacheConfigurator = this.subscriberContext.geQueryCacheConfigurator();
        queryCacheConfigurator.removeConfiguration(mapName, cacheName);
    }
}

