/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.AbstractMapTableResolver;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.schema.map.sample.MapSampleMetadata;
import com.hazelcast.sql.impl.schema.map.sample.MapSampleMetadataResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class PartitionedMapTableResolver
extends AbstractMapTableResolver {
    private static final List<List<String>> SEARCH_PATHS = Collections.singletonList(Arrays.asList("hazelcast", "partitioned"));

    public PartitionedMapTableResolver(NodeEngine nodeEngine, JetMapMetadataResolver jetMapMetadataResolver) {
        super(nodeEngine, jetMapMetadataResolver, SEARCH_PATHS);
    }

    @Override
    @Nonnull
    public List<Table> getTables() {
        MapService mapService = (MapService)this.nodeEngine.getService("hz:impl:mapService");
        MapServiceContext context = mapService.getMapServiceContext();
        ArrayList<Table> res = new ArrayList<Table>();
        HashSet<String> knownNames = new HashSet<String>();
        for (String string : context.getMapContainers().keySet()) {
            PartitionedMapTable table = this.createTable(this.nodeEngine, context, string);
            if (table == null) continue;
            res.add(table);
            knownNames.add(string);
        }
        for (Map.Entry entry : this.nodeEngine.getConfig().getMapConfigs().entrySet()) {
            String configMapName = (String)entry.getKey();
            if (configMapName.contains("*") || !knownNames.add(configMapName)) continue;
            res.add(PartitionedMapTableResolver.emptyError(configMapName));
        }
        return res;
    }

    private PartitionedMapTable createTable(NodeEngine nodeEngine, MapServiceContext context, String name) {
        try {
            MapContainer mapContainer = context.getMapContainer(name);
            if (mapContainer == null) {
                return null;
            }
            boolean hd = mapContainer.getMapConfig().getInMemoryFormat() == InMemoryFormat.NATIVE;
            FieldsMetadata fieldsMetadata = hd ? this.getHdMapFields(mapContainer) : this.getHeapMapFields(context, name);
            if (fieldsMetadata.emptyError) {
                return PartitionedMapTableResolver.emptyError(name);
            }
            if (fieldsMetadata.hdError) {
                return PartitionedMapTableResolver.hdError(name);
            }
            MapSampleMetadata keyMetadata = fieldsMetadata.keyMetadata;
            MapSampleMetadata valueMetadata = fieldsMetadata.valueMetadata;
            List<TableField> fields = PartitionedMapTableResolver.mergeMapFields(keyMetadata.getFields(), valueMetadata.getFields());
            long estimatedRowCount = MapTableUtils.estimatePartitionedMapRowCount(nodeEngine, context, name);
            List<MapTableIndex> indexes = MapTableUtils.getPartitionedMapIndexes(mapContainer, fields);
            return new PartitionedMapTable("partitioned", name, name, fields, new ConstantTableStatistics(estimatedRowCount), keyMetadata.getDescriptor(), valueMetadata.getDescriptor(), keyMetadata.getJetMetadata(), valueMetadata.getJetMetadata(), indexes, hd);
        }
        catch (QueryException e) {
            return new PartitionedMapTable(name, e);
        }
        catch (Exception e) {
            QueryException e0 = QueryException.error("Failed to get metadata for IMap " + name + ": " + e.getMessage(), e);
            return new PartitionedMapTable(name, e0);
        }
    }

    private FieldsMetadata getHeapMapFields(MapServiceContext context, String name) {
        for (PartitionContainer partitionContainer : context.getPartitionContainers()) {
            Iterator<Map.Entry<Data, Record>> recordStoreIterator;
            RecordStore recordStore = partitionContainer.getExistingRecordStore(name);
            if (recordStore == null || !(recordStoreIterator = recordStore.iterator()).hasNext()) continue;
            Map.Entry<Data, Record> entry = recordStoreIterator.next();
            return this.getFieldMetadata(entry.getKey(), entry.getValue().getValue());
        }
        return FieldsMetadata.EMPTY_ERROR;
    }

    private FieldsMetadata getHdMapFields(MapContainer mapContainer) {
        if (!this.nodeEngine.getProperties().getBoolean(ClusterProperty.GLOBAL_HD_INDEX_ENABLED)) {
            return FieldsMetadata.HD_ERROR;
        }
        InternalIndex[] indexes = mapContainer.getIndexes().getIndexes();
        if (indexes == null || indexes.length == 0) {
            return FieldsMetadata.HD_ERROR;
        }
        InternalIndex index = indexes[0];
        Iterator<QueryableEntry> entryIterator = index.getSqlRecordIterator();
        if (!entryIterator.hasNext()) {
            return FieldsMetadata.EMPTY_ERROR;
        }
        QueryableEntry entry = entryIterator.next();
        return this.getFieldMetadata(entry.getKey(), entry.getValue());
    }

    private static PartitionedMapTable emptyError(String mapName) {
        QueryException error = QueryException.error("Cannot resolve IMap schema because it doesn't have entries on the local member: " + mapName);
        return new PartitionedMapTable(mapName, error);
    }

    private static PartitionedMapTable hdError(String mapName) {
        QueryException error = QueryException.error("Cannot query the IMap \"" + mapName + "\" with InMemoryFormat.NATIVE because it does not have global indexes (please make sure that the IMap has at least one index and the property \"" + ClusterProperty.GLOBAL_HD_INDEX_ENABLED.getName() + "\" is set to \"true\")");
        return new PartitionedMapTable(mapName, error);
    }

    private FieldsMetadata getFieldMetadata(Object key, Object value) {
        InternalSerializationService ss = (InternalSerializationService)this.nodeEngine.getSerializationService();
        MapSampleMetadata keyMetadata = MapSampleMetadataResolver.resolve(ss, this.jetMapMetadataResolver, key, true);
        MapSampleMetadata valueMetadata = MapSampleMetadataResolver.resolve(ss, this.jetMapMetadataResolver, value, false);
        return new FieldsMetadata(keyMetadata, valueMetadata);
    }

    private static final class FieldsMetadata {
        private static final FieldsMetadata EMPTY_ERROR = new FieldsMetadata(null, null, true, false);
        private static final FieldsMetadata HD_ERROR = new FieldsMetadata(null, null, false, true);
        private final MapSampleMetadata keyMetadata;
        private final MapSampleMetadata valueMetadata;
        private final boolean emptyError;
        private final boolean hdError;

        private FieldsMetadata(MapSampleMetadata keyMetadata, MapSampleMetadata valueMetadata) {
            this(keyMetadata, valueMetadata, false, false);
        }

        private FieldsMetadata(MapSampleMetadata keyMetadata, MapSampleMetadata valueMetadata, boolean emptyError, boolean hdError) {
            this.keyMetadata = keyMetadata;
            this.valueMetadata = valueMetadata;
            this.emptyError = emptyError;
            this.hdError = hdError;
        }
    }
}

