/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.management.dto.MCEventDTO;

public final class MCEventCodec {
    private static final int TIMESTAMP_FIELD_OFFSET = 0;
    private static final int TYPE_FIELD_OFFSET = 8;
    private static final int INITIAL_FRAME_SIZE = 12;

    private MCEventCodec() {
    }

    public static void encode(ClientMessage clientMessage, MCEventDTO mCEvent) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[12]);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 0, mCEvent.getTimestamp());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, mCEvent.getType());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, mCEvent.getDataJson());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MCEventDTO decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        long timestamp = FixedSizeTypesCodec.decodeLong(initialFrame.content, 0);
        int type = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        String dataJson = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new MCEventDTO(timestamp, type, dataJson);
    }
}

