/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFlakeIdGeneratorConfig;
import com.hazelcast.client.config.ClientIcmpPingConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.config.ProxyFactoryConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.util.RandomLB;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.spring.AbstractHazelcastBeanDefinitionParser;
import com.hazelcast.util.StringUtil;
import java.util.ArrayList;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class HazelcastClientBeanDefinitionParser
extends AbstractHazelcastBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        SpringXmlBuilder springXmlBuilder = new SpringXmlBuilder(parserContext);
        return springXmlBuilder.handleClient(element);
    }

    public class SpringXmlBuilder
    extends AbstractHazelcastBeanDefinitionParser.SpringXmlBuilderHelper {
        private static final int INITIAL_CAPACITY = 10;
        private final ParserContext parserContext;
        private final BeanDefinitionBuilder builder;
        private final ManagedMap<String, BeanDefinition> nearCacheConfigMap;
        private final ManagedMap<String, BeanDefinition> flakeIdGeneratorConfigMap;

        SpringXmlBuilder(ParserContext parserContext) {
            this(parserContext, BeanDefinitionBuilder.rootBeanDefinition(HazelcastClient.class).setFactoryMethod("newHazelcastClient").setDestroyMethodName("shutdown"));
        }

        public SpringXmlBuilder(ParserContext parserContext, BeanDefinitionBuilder builder) {
            super(HazelcastClientBeanDefinitionParser.this);
            this.nearCacheConfigMap = new ManagedMap();
            this.flakeIdGeneratorConfigMap = new ManagedMap();
            this.parserContext = parserContext;
            this.builder = builder;
            this.configBuilder = BeanDefinitionBuilder.rootBeanDefinition(ClientConfig.class);
            this.configBuilder.addPropertyValue("nearCacheConfigMap", this.nearCacheConfigMap);
            this.configBuilder.addPropertyValue("flakeIdGeneratorConfigMap", this.flakeIdGeneratorConfigMap);
        }

        public AbstractBeanDefinition handleClient(Element element) {
            this.handleCommonBeanAttributes(element, this.builder, this.parserContext);
            this.handleClientAttributes(element);
            for (Node node : SpringXmlBuilder.childElements(element)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(node);
                if ("group".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, GroupConfig.class, "groupConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("properties".equals(nodeName)) {
                    this.handleProperties(node, this.configBuilder);
                    continue;
                }
                if ("network".equals(nodeName)) {
                    this.handleNetwork(node);
                    continue;
                }
                if ("listeners".equals(nodeName)) {
                    ManagedList listeners = this.parseListeners(node, ListenerConfig.class);
                    this.configBuilder.addPropertyValue("listenerConfigs", (Object)listeners);
                    continue;
                }
                if ("serialization".equals(nodeName)) {
                    this.handleSerialization(node);
                    continue;
                }
                if ("proxy-factories".equals(nodeName)) {
                    ManagedList list = this.parseProxyFactories(node, ProxyFactoryConfig.class);
                    this.configBuilder.addPropertyValue("proxyFactoryConfigs", (Object)list);
                    continue;
                }
                if ("load-balancer".equals(nodeName)) {
                    this.handleLoadBalancer(node);
                    continue;
                }
                if ("near-cache".equals(nodeName)) {
                    this.handleNearCache(node);
                    continue;
                }
                if ("spring-aware".equals(nodeName)) {
                    this.handleSpringAware();
                    continue;
                }
                if ("query-caches".equals(nodeName)) {
                    ManagedMap queryCaches = this.getQueryCaches(node);
                    this.configBuilder.addPropertyValue("queryCacheConfigs", (Object)queryCaches);
                    continue;
                }
                if ("connection-strategy".equals(nodeName)) {
                    this.createAndFillBeanBuilder(node, ClientConnectionStrategyConfig.class, "connectionStrategyConfig", this.configBuilder, new String[0]);
                    continue;
                }
                if ("user-code-deployment".equals(nodeName)) {
                    this.handleUserCodeDeployment(node);
                    continue;
                }
                if (!"flake-id-generator".equals(nodeName)) continue;
                this.handleFlakeIdGenerator(node);
            }
            this.builder.addConstructorArgValue((Object)this.configBuilder.getBeanDefinition());
            return this.builder.getBeanDefinition();
        }

        private void handleUserCodeDeployment(Node node) {
            BeanDefinitionBuilder userCodeDeploymentConfig = this.createBeanBuilder(ClientUserCodeDeploymentConfig.class);
            ArrayList<String> jarPaths = new ArrayList<String>(10);
            ArrayList<String> classNames = new ArrayList<String>(10);
            this.fillAttributeValues(node, userCodeDeploymentConfig, new String[0]);
            for (Node child : SpringXmlBuilder.childElements(node)) {
                String nodeName1;
                String nodeName = SpringXmlBuilder.cleanNodeName(child);
                if ("jarpaths".equals(nodeName)) {
                    for (Node child1 : SpringXmlBuilder.childElements(child)) {
                        nodeName1 = SpringXmlBuilder.cleanNodeName(child1);
                        if (!"jarpath".equals(nodeName1)) continue;
                        jarPaths.add(this.getTextContent(child1));
                    }
                    continue;
                }
                if (!"classnames".equals(nodeName)) continue;
                for (Node child1 : SpringXmlBuilder.childElements(child)) {
                    nodeName1 = SpringXmlBuilder.cleanNodeName(child1);
                    if (!"classname".equals(nodeName1)) continue;
                    classNames.add(this.getTextContent(child1));
                }
            }
            userCodeDeploymentConfig.addPropertyValue("jarPaths", jarPaths);
            userCodeDeploymentConfig.addPropertyValue("classNames", classNames);
            this.configBuilder.addPropertyValue("userCodeDeploymentConfig", (Object)userCodeDeploymentConfig.getBeanDefinition());
        }

        private void handleClientAttributes(Element element) {
            NamedNodeMap attributes = element.getAttributes();
            if (attributes != null) {
                for (int a = 0; a < attributes.getLength(); ++a) {
                    Node att = attributes.item(a);
                    String name = att.getNodeName();
                    String value = att.getNodeValue();
                    if ("executor-pool-size".equals(name)) {
                        this.configBuilder.addPropertyValue("executorPoolSize", (Object)value);
                        continue;
                    }
                    if (!"credentials-ref".equals(name)) continue;
                    this.configBuilder.addPropertyReference("credentials", value);
                }
            }
        }

        private void handleNetwork(Node node) {
            BeanDefinitionBuilder clientNetworkConfig = this.createBeanBuilder(ClientNetworkConfig.class);
            ArrayList<String> members = new ArrayList<String>(10);
            this.fillAttributeValues(node, clientNetworkConfig, new String[0]);
            for (Node child : SpringXmlBuilder.childElements(node)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(child);
                if ("member".equals(nodeName)) {
                    members.add(this.getTextContent(child));
                    continue;
                }
                if ("socket-options".equals(nodeName)) {
                    this.createAndFillBeanBuilder(child, SocketOptions.class, "socketOptions", clientNetworkConfig, new String[0]);
                    continue;
                }
                if ("socket-interceptor".equals(nodeName)) {
                    this.handleSocketInterceptorConfig(child, clientNetworkConfig);
                    continue;
                }
                if ("ssl".equals(nodeName)) {
                    this.handleSSLConfig(child, clientNetworkConfig);
                    continue;
                }
                if ("aws".equals(nodeName)) {
                    this.handleAws(child, clientNetworkConfig);
                    continue;
                }
                if ("discovery-strategies".equals(nodeName)) {
                    this.handleDiscoveryStrategies(child, clientNetworkConfig);
                    continue;
                }
                if ("outbound-ports".equals(nodeName)) {
                    this.handleOutboundPorts(child, clientNetworkConfig);
                    continue;
                }
                if (!"icmp-ping".equals(nodeName)) continue;
                this.createAndFillBeanBuilder(child, ClientIcmpPingConfig.class, "clientIcmpPingConfig", clientNetworkConfig, new String[0]);
            }
            clientNetworkConfig.addPropertyValue("addresses", members);
            this.configBuilder.addPropertyValue("networkConfig", (Object)clientNetworkConfig.getBeanDefinition());
        }

        private void handleAws(Node node, BeanDefinitionBuilder clientNetworkConfig) {
            this.createAndFillBeanBuilder(node, ClientAwsConfig.class, "awsConfig", clientNetworkConfig, new String[0]);
        }

        private void handleSSLConfig(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            String implementation;
            BeanDefinitionBuilder sslConfigBuilder = this.createBeanBuilder(SSLConfig.class);
            String implAttribute = "factory-implementation";
            this.fillAttributeValues(node, sslConfigBuilder, implAttribute);
            Node implNode = node.getAttributes().getNamedItem(implAttribute);
            String string = implementation = implNode != null ? this.getTextContent(implNode) : null;
            if (implementation != null) {
                sslConfigBuilder.addPropertyReference(this.xmlToJavaName(implAttribute), implementation);
            }
            for (Node child : SpringXmlBuilder.childElements(node)) {
                String name = SpringXmlBuilder.cleanNodeName(child);
                if (!"properties".equals(name)) continue;
                this.handleProperties(child, sslConfigBuilder);
            }
            networkConfigBuilder.addPropertyValue("SSLConfig", (Object)sslConfigBuilder.getBeanDefinition());
        }

        private void handleLoadBalancer(Node node) {
            String type = this.getAttribute(node, "type");
            if ("random".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RandomLB());
            } else if ("round-robin".equals(type)) {
                this.configBuilder.addPropertyValue("loadBalancer", (Object)new RoundRobinLB());
            }
        }

        private void handleNearCache(Node node) {
            BeanDefinitionBuilder nearCacheConfigBuilder = this.createBeanBuilder(NearCacheConfig.class);
            this.fillAttributeValues(node, nearCacheConfigBuilder, new String[0]);
            for (Node childNode : SpringXmlBuilder.childElements(node)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(childNode);
                if ("eviction".equals(nodeName)) {
                    this.handleEvictionConfig(childNode, nearCacheConfigBuilder);
                    continue;
                }
                if (!"preloader".equals(nodeName)) continue;
                this.handlePreloaderConfig(childNode, nearCacheConfigBuilder);
            }
            String name = this.getAttribute(node, "name");
            this.nearCacheConfigMap.put((Object)name, (Object)nearCacheConfigBuilder.getBeanDefinition());
        }

        private void handleFlakeIdGenerator(Node node) {
            BeanDefinitionBuilder configBuilder = this.createBeanBuilder(ClientFlakeIdGeneratorConfig.class);
            this.fillAttributeValues(node, configBuilder, new String[0]);
            String name = this.getAttribute(node, "name");
            this.flakeIdGeneratorConfigMap.put((Object)name, (Object)configBuilder.getBeanDefinition());
        }

        private void handleEvictionConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
        }

        private void handlePreloaderConfig(Node node, BeanDefinitionBuilder configBuilder) {
            configBuilder.addPropertyValue("preloaderConfig", (Object)this.getPreloaderConfig(node));
        }

        private ManagedMap getQueryCaches(Node childNode) {
            ManagedMap queryCaches = new ManagedMap();
            for (Node queryCacheNode : SpringXmlBuilder.childElements(childNode)) {
                this.parseQueryCache((ManagedMap<String, ManagedMap<String, BeanDefinition>>)queryCaches, queryCacheNode);
            }
            return queryCaches;
        }

        private void parseQueryCache(ManagedMap<String, ManagedMap<String, BeanDefinition>> queryCaches, Node queryCacheNode) {
            BeanDefinitionBuilder builder = this.createBeanBuilder(QueryCacheConfig.class);
            NamedNodeMap attributes = queryCacheNode.getAttributes();
            String mapName = this.getTextContent(attributes.getNamedItem("map-name"));
            String cacheName = this.getTextContent(attributes.getNamedItem("name"));
            for (Node node : SpringXmlBuilder.childElements(queryCacheNode)) {
                String nodeName = SpringXmlBuilder.cleanNodeName(node);
                String textContent = this.getTextContent(node);
                this.parseQueryCacheInternal(builder, node, nodeName, textContent);
            }
            builder.addPropertyValue("name", (Object)cacheName);
            ManagedMap configMap = (ManagedMap)queryCaches.get((Object)mapName);
            if (configMap == null) {
                configMap = new ManagedMap();
                queryCaches.put((Object)mapName, (Object)configMap);
            }
            configMap.put((Object)cacheName, (Object)builder.getBeanDefinition());
        }

        private void parseQueryCacheInternal(BeanDefinitionBuilder builder, Node node, String nodeName, String textContent) {
            if ("predicate".equals(nodeName)) {
                BeanDefinitionBuilder predicateBuilder = this.getPredicate(node, textContent);
                builder.addPropertyValue("predicateConfig", (Object)predicateBuilder.getBeanDefinition());
            } else if ("entry-listeners".equals(nodeName)) {
                ManagedList<BeanDefinition> listeners = this.getEntryListeners(node);
                builder.addPropertyValue("entryListenerConfigs", listeners);
            } else if ("include-value".equals(nodeName)) {
                boolean includeValue = SpringXmlBuilder.getBooleanValue(textContent);
                builder.addPropertyValue("includeValue", (Object)includeValue);
            } else if ("batch-size".equals(nodeName)) {
                int batchSize = SpringXmlBuilder.getIntegerValue("batch-size", textContent.trim());
                builder.addPropertyValue("batchSize", (Object)batchSize);
            } else if ("buffer-size".equals(nodeName)) {
                int bufferSize = SpringXmlBuilder.getIntegerValue("buffer-size", textContent.trim());
                builder.addPropertyValue("bufferSize", (Object)bufferSize);
            } else if ("delay-seconds".equals(nodeName)) {
                int delaySeconds = SpringXmlBuilder.getIntegerValue("delay-seconds", textContent.trim());
                builder.addPropertyValue("delaySeconds", (Object)delaySeconds);
            } else if ("in-memory-format".equals(nodeName)) {
                String value = textContent.trim();
                builder.addPropertyValue("inMemoryFormat", (Object)InMemoryFormat.valueOf(StringUtil.upperCaseInternal(value)));
            } else if ("coalesce".equals(nodeName)) {
                boolean coalesce = SpringXmlBuilder.getBooleanValue(textContent);
                builder.addPropertyValue("coalesce", (Object)coalesce);
            } else if ("populate".equals(nodeName)) {
                boolean populate = SpringXmlBuilder.getBooleanValue(textContent);
                builder.addPropertyValue("populate", (Object)populate);
            } else if ("indexes".equals(nodeName)) {
                ManagedList<BeanDefinition> indexes = this.getIndexes(node);
                builder.addPropertyValue("indexConfigs", indexes);
            } else if ("eviction".equals(nodeName)) {
                builder.addPropertyValue("evictionConfig", (Object)this.getEvictionConfig(node));
            }
        }

        private BeanDefinitionBuilder getPredicate(Node node, String textContent) {
            BeanDefinitionBuilder predicateBuilder = this.createBeanBuilder(PredicateConfig.class);
            String predicateType = this.getTextContent(node.getAttributes().getNamedItem("type"));
            if ("sql".equals(predicateType)) {
                predicateBuilder.addPropertyValue("sql", (Object)textContent);
            } else if ("class-name".equals(predicateType)) {
                predicateBuilder.addPropertyValue("className", (Object)textContent);
            }
            return predicateBuilder;
        }

        private ManagedList<BeanDefinition> getIndexes(Node node) {
            ManagedList indexes = new ManagedList();
            for (Node indexNode : SpringXmlBuilder.childElements(node)) {
                BeanDefinitionBuilder indexConfBuilder = this.createBeanBuilder(MapIndexConfig.class);
                this.fillAttributeValues(indexNode, indexConfBuilder, new String[0]);
                indexes.add((Object)indexConfBuilder.getBeanDefinition());
            }
            return indexes;
        }

        private ManagedList<BeanDefinition> getEntryListeners(Node node) {
            ManagedList listeners = new ManagedList();
            String implementationAttr = "implementation";
            for (Node listenerNode : SpringXmlBuilder.childElements(node)) {
                BeanDefinitionBuilder listenerConfBuilder = this.createBeanBuilder(EntryListenerConfig.class);
                this.fillAttributeValues(listenerNode, listenerConfBuilder, implementationAttr);
                Node implementationNode = listenerNode.getAttributes().getNamedItem(implementationAttr);
                if (implementationNode != null) {
                    listenerConfBuilder.addPropertyReference(implementationAttr, this.getTextContent(implementationNode));
                }
                listeners.add((Object)listenerConfBuilder.getBeanDefinition());
            }
            return listeners;
        }

        private void handleOutboundPorts(Node node, BeanDefinitionBuilder networkConfigBuilder) {
            ManagedList outboundPorts = new ManagedList();
            for (Node child : SpringXmlBuilder.childElements(node)) {
                String name = SpringXmlBuilder.cleanNodeName(child);
                if (!"ports".equals(name)) continue;
                String value = this.getTextContent(child);
                outboundPorts.add((Object)value);
            }
            networkConfigBuilder.addPropertyValue("outboundPortDefinitions", (Object)outboundPorts);
        }
    }
}

