/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi.ant;

import com.openexchange.build.utils.Version;
import com.openexchange.osgi.data.AbstractModule;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

public class Tools {
    private Tools() {
    }

    public static List<AbstractModule> readClasspathModules(Path classpath) throws IOException {
        return com.openexchange.osgi.Tools.readClasspathModules(classpath.list());
    }

    public static void setProjectProperties(Project project, AbstractModule module, String buildType) {
        Set<String> sourceDirs;
        Version javaVersion;
        try {
            javaVersion = Version.parse((String)System.getProperty("java.version").replace('_', '-'));
        }
        catch (Exception e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
        StringBuilder requiredClasspath = new StringBuilder();
        for (String string : module.getRequiredClasspath(new Version(1, 8, 0, 0).compareTo(javaVersion) < 0)) {
            requiredClasspath.append(string);
            requiredClasspath.append(',');
        }
        if (requiredClasspath.length() > 0) {
            requiredClasspath.setLength(requiredClasspath.length() - 1);
        }
        project.log(module.getName() + ".requiredClasspath: " + requiredClasspath, 4);
        project.setInheritedProperty(module.getName() + ".requiredClasspath", requiredClasspath.toString());
        StringBuilder runtimeClasspath = new StringBuilder();
        for (String classpathEntry : module.getFullRuntimeClasspath()) {
            runtimeClasspath.append(classpathEntry);
            runtimeClasspath.append(',');
        }
        if (runtimeClasspath.length() > 0) {
            runtimeClasspath.setLength(runtimeClasspath.length() - 1);
        }
        project.log(module.getName() + ".runtimeClasspath: " + runtimeClasspath, 4);
        project.setInheritedProperty(module.getName() + ".runtimeClasspath", runtimeClasspath.toString());
        StringBuilder stringBuilder = new StringBuilder();
        if ("bundle".equals(buildType)) {
            sourceDirs = module.getSourceDirs();
        } else if ("tests".equals(buildType)) {
            sourceDirs = module.getTestSourceDirs();
        } else if ("osgiTests".equals(buildType)) {
            sourceDirs = module.getSourceDirs();
        } else {
            throw new BuildException("Unknown build type \"" + buildType + "\".");
        }
        for (String sourceDir : sourceDirs) {
            stringBuilder.append(sourceDir);
            stringBuilder.append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        project.log(module.getName() + ".sourceDirs: " + stringBuilder, 4);
        project.setInheritedProperty(module.getName() + ".sourceDirs", stringBuilder.toString());
    }
}

