/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.appenders;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import com.openexchange.logback.extensions.appenders.AppenderProperty;
import com.openexchange.logback.extensions.appenders.CommonAppenderProperty;
import com.openexchange.logback.extensions.appenders.ExceptionHandler;
import com.openexchange.logback.extensions.appenders.RemoteAppenderMBean;
import com.openexchange.logback.extensions.encoders.JSONEncoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRemoteAppender<C extends Closeable>
extends AppenderBase<ILoggingEvent>
implements Runnable,
RemoteAppenderMBean {
    private static final Object PRESENT = new Object();
    private static final int ALLOWED_APPEND_REPEATS = 5;
    private final ConcurrentMap<Thread, Object> guard = new ConcurrentHashMap<Thread, Object>(32, 0.9f, 1);
    private final AtomicInteger statusRepeatCount = new AtomicInteger(0);
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    protected ExceptionHandler exceptionHandler;
    protected Encoder<ILoggingEvent> encoder;
    private static final float LOAD_FACTOR = 0.67f;
    private static final int CONNECTION_TIMEOUT = 5000;
    protected BlockingQueue<ILoggingEvent> queue;
    private int queueSize;
    private int loadThreshold;
    private float loadFactor;
    private Duration eventDelayLimit;
    private int connectionTimeout;
    private boolean alwaysPersistEvents;
    protected Future<C> connectorTask;
    protected Future<?> appenderTask;
    private volatile C connector;
    private OutputStream fallbackOutputStream;

    public void start() {
        this.fallbackOutputStream = System.err;
        if (this.encoder == null) {
            this.addInfo("No 'encoder' set for the '" + this.getAppenderName() + "' appender. Use default 'JSONEncoder'.");
            this.encoder = new JSONEncoder();
        }
        if (this.queueSize <= 0) {
            this.addInfo("'queueSize' is not defined in configuration file. Falling back to default value of '2048'");
            this.queueSize = 2048;
        }
        this.queue = this.newBlockingQueue(this.queueSize);
        this.alwaysPersistEvents = this.getProperty(CommonAppenderProperty.alwaysPersistEvents, false);
        this.loadFactor = this.getProperty(CommonAppenderProperty.loadFactor, Float.valueOf(0.67f)).floatValue();
        this.loadThreshold = (int)(this.loadFactor * (float)this.queueSize);
        this.connectionTimeout = this.getProperty(CommonAppenderProperty.connectionTimeout, 5000);
        this.appenderTask = this.getContext().getScheduledExecutorService().submit(this);
        super.start();
    }

    public final void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly(this.connector);
        this.appenderTask.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        CloseUtil.closeQuietly((Closeable)this.fallbackOutputStream);
        this.postStop();
        super.stop();
    }

    @Override
    public void run() {
        try {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    Callable<C> remoteAppenderConnector = this.createConnector();
                    this.connectorTask = this.activateConnector(remoteAppenderConnector);
                    if (this.connectorTask == null) continue;
                    this.connector = this.waitForConnectorInitialisation();
                    if (this.connector == null) continue;
                    this.dispatchEvents();
                }
                catch (Exception e) {
                    this.exceptionHandler.handle(e);
                }
            }
        }
        catch (Throwable t) {
            this.addError(this.name + " appender is shutting down.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(ILoggingEvent eventObject) {
        Thread currentThread = Thread.currentThread();
        if (null != this.guard.putIfAbsent(currentThread, PRESENT)) {
            return;
        }
        try {
            if (!this.started) {
                if (this.statusRepeatCount.getAndIncrement() < 5) {
                    this.addStatus((Status)new WarnStatus("Attempted to append to non started appender [" + this.name + "].", (Object)this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
        }
        catch (Exception e) {
            if (this.exceptionCount.getAndIncrement() < 5) {
                this.addError("Appender [" + this.name + "] failed to append.", e);
            }
        }
        finally {
            this.guard.remove(currentThread);
        }
    }

    protected void append(ILoggingEvent event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        int maxRetry = 2;
        boolean inserted = false;
        int i = maxRetry;
        while (!inserted && i-- > 0) {
            inserted = this.queue.offer(event);
            if (inserted) continue;
            try {
                this.cleanQueueIfNecessary();
            }
            catch (IOException e) {
                this.addError("Failed while cleaning queue.", e);
            }
        }
        if (!inserted) {
            this.addError("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded", null);
        }
    }

    protected void postStop() {
    }

    @Override
    public int getEventsInQueue() {
        return this.queue.size();
    }

    protected abstract String getAppenderName();

    protected abstract void dispatchEvents();

    protected abstract Callable<C> createConnector();

    protected abstract C waitForConnectorInitialisation() throws Exception;

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    public void setQueueSize(int queueSize) {
        if (this.queue != null) {
            throw new IllegalStateException("Queue size must be set before initialization");
        }
        this.queueSize = queueSize;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getNumberOfElementsInQueue() {
        return this.queue.size();
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setEventDelayLimit(Duration eventDelayLimit) {
        this.eventDelayLimit = eventDelayLimit;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    protected C getConnector() {
        return this.connector;
    }

    private Future<C> activateConnector(Callable<C> connector) {
        this.addInfo("Submitting connector to the executor service...");
        Future<C> task = this.getContext().getScheduledExecutorService().submit(connector);
        this.addInfo("Connector task returned.");
        return task;
    }

    private BlockingQueue<ILoggingEvent> newBlockingQueue(int queueSize) {
        return (BlockingQueue)((Object)(queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanQueueIfNecessary() throws IOException {
        int qSize = this.queue.size();
        if (qSize < this.loadThreshold) {
            String message = "Event queue holds " + qSize + " log events.";
            this.addInfo(message + " Not flushing yet. Load threshold of " + this.loadThreshold + " is not reached.");
            return;
        }
        AbstractRemoteAppender abstractRemoteAppender = this;
        synchronized (abstractRemoteAppender) {
            qSize = this.queue.size();
            if (qSize < this.loadThreshold) {
                this.addInfo("Another thread flushed the queue in the meantime.");
                return;
            }
            String message = "Event queue holds " + qSize + " log events.";
            if (this.alwaysPersistEvents) {
                this.addInfo(message + " Load threshold of " + this.loadThreshold + " is reached. Flushing...");
                this.flushQueue(qSize);
            } else {
                this.queue.clear();
                this.addInfo("Cleared event queue. Discarded " + qSize + " log events.");
            }
        }
    }

    private void flushQueue(int queueSize) throws IOException {
        int events;
        for (events = 0; events < queueSize; ++events) {
            ILoggingEvent event = (ILoggingEvent)this.queue.poll();
            if (event == null) {
                return;
            }
            this.writeBytesToFallbackOutput(this.encoder.encode((Object)event));
        }
        this.addInfo("Successfully flushed " + events + " out of " + queueSize + " events.");
    }

    public void writeEventToFallbackOutput(ILoggingEvent event) {
        if (event == null) {
            return;
        }
        try {
            this.writeBytesToFallbackOutput(this.encoder.encode((Object)event));
        }
        catch (IOException e) {
            this.addError("An I/O error occurred while flushing failed event to fallback output.", e);
        }
    }

    public void writeBytesToFallbackOutput(byte[] byteArray) throws IOException {
        this.writeBytes(this.fallbackOutputStream, byteArray);
    }

    protected void writeBytes(OutputStream outputStream, byte[] byteArray) throws IOException {
        if (byteArray == null || outputStream == null) {
            return;
        }
        outputStream.write(byteArray);
        outputStream.flush();
    }

    protected <T> T getProperty(AppenderProperty property, T defaultValue) {
        String propertyName = property.getPropertyName(this.getAppenderName());
        String value = this.context.getProperty(propertyName);
        if (value == null) {
            this.addInfo("'" + propertyName + "' property is not defined in the configuration file. Falling back to default value of '" + defaultValue + "'");
            return defaultValue;
        }
        Class<?> type = property.getCoerceType();
        try {
            if (Float.TYPE.equals(type) || Float.class.equals(type)) {
                return (T)type.cast(Float.valueOf(Float.parseFloat(value)));
            }
            if (Integer.TYPE.equals(type) || Integer.class.equals(type)) {
                return (T)type.cast(Integer.parseInt(value));
            }
            if (Boolean.TYPE.equals(type) || Boolean.class.equals(type)) {
                return (T)type.cast(Boolean.parseBoolean(value));
            }
            return defaultValue;
        }
        catch (NumberFormatException e) {
            this.addWarn("The value of '" + propertyName + "' is not parsable as '" + type.getSimpleName() + "'. Falling back to default value of '" + defaultValue + "'");
            return defaultValue;
        }
    }
}

