/*
 * @copyright Copyright (c) Open-Xchange GmbH, Germany <info@open-xchange.com>
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OX App Suite.  If not, see <https://www.gnu.org/licenses/agpl-3.0.txt>.
 *
 * Any use of the work other than as authorized under this license or copyright law is prohibited.
 *
 */

package com.openexchange.twitter;

import com.openexchange.i18n.LocalizableStrings;
import twitter4j.TwitterException;

/**
 * {@link TwitterExceptionMessages} - Exception messages for {@link TwitterException} that must be translated.
 *
 * @author <a href="mailto:thorben.betten@open-xchange.com">Thorben Betten</a>
 */
public final class TwitterExceptionMessages implements LocalizableStrings {

    // Please (re-)authorize your Twitter accounts.
    // Twitter responded with: %1$s
    public static final String REAUTHORIZE_ERROR_MSG = "Please (re-)authorize your Twitter accounts.\nTwitter responded with: %1$s";

    // The request is understood, but it has been refused or access is not allowed: %1$s
    public static final String DENIED_ERROR_MSG = "The request is understood, but it has been refused or access is not allowed: %1$s";

    // Invalid format in search query.
    public static final String INVALID_QUERY_MSG = "Invalid format in search query.";

    /**
     * Initializes a new {@link TwitterExceptionMessages}.
     */
    private TwitterExceptionMessages() {
        super();
    }

}
