/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.TriTuple;
import com.hazelcast.spi.annotation.Beta;
import com.hazelcast.spi.annotation.PrivateApi;
import java.util.Map;

@Beta
@PrivateApi
public final class CompactSerializationConfigAccessor {
    private CompactSerializationConfigAccessor() {
    }

    public static void registerExplicitSerializer(CompactSerializationConfig compactSerializationConfig, String className, String typeName, String serializerClassName) {
        Preconditions.checkNotNull(className, "Class name cannot be null");
        Preconditions.checkNotNull(typeName, "Type name cannot be null");
        Preconditions.checkNotNull(serializerClassName, "Explicit serializer class name cannot be null");
        CompactSerializationConfigAccessor.register(compactSerializationConfig, className, typeName, serializerClassName);
    }

    public static void registerReflectiveSerializer(CompactSerializationConfig compactSerializationConfig, String className) {
        Preconditions.checkNotNull(className, "Class name cannot be null");
        CompactSerializationConfigAccessor.register(compactSerializationConfig, className, className, null);
    }

    public static Map<String, TriTuple<String, String, String>> getNamedRegistries(CompactSerializationConfig compactSerializationConfig) {
        return compactSerializationConfig.typeNameToNamedRegistryMap;
    }

    private static void register(CompactSerializationConfig compactSerializationConfig, String className, String typeName, String explicitSerializerClassName) {
        TriTuple<String, String, String> registry = TriTuple.of(className, typeName, explicitSerializerClassName);
        TriTuple<String, String, String> oldRegistry = compactSerializationConfig.typeNameToNamedRegistryMap.putIfAbsent(typeName, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for the type name " + typeName);
        }
        oldRegistry = compactSerializationConfig.classNameToNamedRegistryMap.putIfAbsent(className, registry);
        if (oldRegistry != null) {
            throw new InvalidConfigurationException("Already have a registry for class name " + className);
        }
    }
}

