/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.CheckReplicaVersion;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.PartitionSpecificRunnable;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;

final class CheckReplicaVersionTask
implements PartitionSpecificRunnable,
UrgentSystemOperation {
    private static final int OPERATION_TRY_COUNT = 10;
    private static final int OPERATION_TRY_PAUSE_MILLIS = 250;
    private final NodeEngineImpl nodeEngine;
    private final InternalPartitionServiceImpl partitionService;
    private final int partitionId;
    private final int replicaIndex;
    private final ExecutionCallback callback;

    CheckReplicaVersionTask(NodeEngineImpl nodeEngine, InternalPartitionServiceImpl partitionService, int partitionId, int replicaIndex, ExecutionCallback callback) {
        this.nodeEngine = nodeEngine;
        this.partitionService = partitionService;
        this.partitionId = partitionId;
        if (replicaIndex < 1 || replicaIndex > 6) {
            throw new IllegalArgumentException("Replica index should be in range [1-6]");
        }
        this.replicaIndex = replicaIndex;
        this.callback = callback;
    }

    @Override
    public void run() {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.replicaIndex;
        InternalPartition partition = this.partitionService.getPartition(partitionId);
        if (partition.isMigrating()) {
            this.notifyCallback(false);
            return;
        }
        Address target = partition.getReplicaAddress(replicaIndex);
        if (target == null) {
            this.notifyCallback(false);
            return;
        }
        this.invokeCheckReplicaVersion(partitionId, replicaIndex, target);
    }

    private void invokeCheckReplicaVersion(int partitionId, int replicaIndex, Address target) {
        long[] currentVersions = this.partitionService.getPartitionReplicaVersions(partitionId);
        long currentReplicaVersion = currentVersions[replicaIndex - 1];
        if (currentReplicaVersion <= 0L) {
            this.notifyCallback(true);
            return;
        }
        CheckReplicaVersion op = new CheckReplicaVersion(currentReplicaVersion, this.shouldInvoke());
        op.setPartitionId(partitionId).setReplicaIndex(replicaIndex).setServiceName("hz:core:partitionService");
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        if (this.shouldInvoke()) {
            operationService.createInvocationBuilder("hz:core:partitionService", (Operation)op, target).setExecutionCallback(this.callback).setTryCount(10).setTryPauseMillis(250L).invoke();
        } else {
            operationService.send(op, target);
        }
    }

    private void notifyCallback(boolean result) {
        if (this.shouldInvoke()) {
            this.callback.onResponse(result);
        }
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    private boolean shouldInvoke() {
        return this.callback != null;
    }
}

