/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.util.Preconditions;

public class CardinalityEstimatorConfig {
    public static final int DEFAULT_SYNC_BACKUP_COUNT = 1;
    public static final int DEFAULT_ASYNC_BACKUP_COUNT = 0;
    private String name = "default";
    private int backupCount = 1;
    private int asyncBackupCount = 0;
    private CardinalityEstimatorConfigReadOnly readOnly;

    public CardinalityEstimatorConfig() {
    }

    public CardinalityEstimatorConfig(String name) {
        this.name = name;
    }

    public CardinalityEstimatorConfig(String name, int backupCount, int asyncBackupCount) {
        this.name = name;
        this.backupCount = Preconditions.checkBackupCount(backupCount, asyncBackupCount);
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(backupCount, asyncBackupCount);
    }

    public CardinalityEstimatorConfig(CardinalityEstimatorConfig config) {
        this(config.getName(), config.getBackupCount(), config.getAsyncBackupCount());
    }

    public String getName() {
        return this.name;
    }

    public CardinalityEstimatorConfig setName(String name) {
        Preconditions.checkNotNull(name);
        this.name = name;
        return this;
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public CardinalityEstimatorConfig setBackupCount(int backupCount) {
        this.backupCount = Preconditions.checkBackupCount(backupCount, this.asyncBackupCount);
        return this;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public CardinalityEstimatorConfig setAsyncBackupCount(int asyncBackupCount) {
        this.asyncBackupCount = Preconditions.checkAsyncBackupCount(this.backupCount, asyncBackupCount);
        return this;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    public String toString() {
        return "CardinalityEstimatorConfig{name='" + this.name + '\'' + ", backupCount=" + this.backupCount + ", asyncBackupCount=" + this.asyncBackupCount + ", readOnly=" + this.readOnly + '}';
    }

    CardinalityEstimatorConfigReadOnly getAsReadOnly() {
        if (this.readOnly == null) {
            this.readOnly = new CardinalityEstimatorConfigReadOnly(this);
        }
        return this.readOnly;
    }

    private static class CardinalityEstimatorConfigReadOnly
    extends CardinalityEstimatorConfig {
        CardinalityEstimatorConfigReadOnly(CardinalityEstimatorConfig config) {
            super(config);
        }

        @Override
        public CardinalityEstimatorConfig setName(String name) {
            throw new UnsupportedOperationException("This config is read-only cardinality estimator: " + this.getName());
        }

        @Override
        public CardinalityEstimatorConfig setBackupCount(int backupCount) {
            throw new UnsupportedOperationException("This config is read-only cardinality estimator: " + this.getName());
        }

        @Override
        public CardinalityEstimatorConfig setAsyncBackupCount(int asyncBackupCount) {
            throw new UnsupportedOperationException("This config is read-only cardinality estimator: " + this.getName());
        }
    }
}

